
<?php $__env->startSection('title', 'Customer Login'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-center">

        <!-- Left Side : Info -->
        <div class="hidden lg:flex flex-col justify-center bg-white shadow rounded-lg p-8 h-[-webkit-fill-available]">
            <h2 class="text-3xl font-semibold text-gray-800 mb-4">
                Welcome Back 👋
            </h2>
            <p class="text-gray-600 mb-6">
                Login to manage your orders, track shipments, and enjoy a faster checkout experience.
            </p>

            <ul class="space-y-3 text-gray-600">
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Order Tracking
                </li>
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Faster Checkout
                </li>
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Secure Account
                </li>
            </ul>
        </div>

        <!-- Right Side : Login Form -->
        <div class="bg-white shadow rounded-lg p-6 md:p-8">

            <h1
                class="text-2xl font-medium mb-6 text-gray-800 relative inline-block after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[<?php echo e($theme->theme_bg); ?>] after:bottom-[-6px] after:left-0">
                🔐 Customer Login
            </h1>

            <?php if(session('error')): ?>
                <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('customer.login')); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>

                <!-- Email -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Email Address</label>
                    <div class="relative">
                        <i class="ri-mail-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="email" name="email" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Password -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Password</label>
                    <div class="relative">
                        <i class="ri-lock-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="password" name="password" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>
                
               <div class="w-full flex justify-end">
                   <a href="<?php echo e(route('customer.forget')); ?>"
                          class="text-sm flex items-center gap-1 text-gray-500 hover:text-[<?php echo e($theme->theme_bg); ?>] transition font-medium">
                        <i class="ri-question-line text-base"></i>
                       Forgot password?
                    </a>
               </div>

                <!-- Submit -->
                <button type="submit"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                    <i class="ri-login-box-line"></i>
                    Login
                </button>
            </form>

            <!-- Footer -->
            <div class="mt-6 text-center text-sm text-gray-600">
                New here?
                <a href="<?php echo e(route('customer.register')); ?>"
                    class="text-[<?php echo e($theme->theme_bg); ?>] font-medium hover:underline">
                    Create an account
                </a>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/customer/auth/login.blade.php ENDPATH**/ ?>