
<?php $__env->startSection('title', 'Forget Password'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-center">

        <!-- Left Info -->
        <div class="hidden lg:flex flex-col justify-center bg-white shadow rounded-lg p-8 h-[-webkit-fill-available]">
            <h2 class="text-3xl font-semibold text-gray-800 mb-4">Forgot Your Password? 🔑</h2>
            <p class="text-gray-600 mb-6">
                Enter your registered email and we'll send you a OTP to reset your password.
            </p>

            <ul class="space-y-3 text-gray-600">
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Fast OTP Delivery
                </li>
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Secure Account
                </li>
                <li class="flex items-center gap-2">
                    <i class="ri-check-line text-[<?php echo e($theme->theme_bg); ?>] text-lg"></i>
                    Easy Reset
                </li>
            </ul>
        </div>

        <!-- Right Form -->
        <div class="bg-white shadow rounded-lg p-6 md:p-8">

            <h1 class="text-2xl font-medium mb-6 text-gray-800 relative inline-block 
                       after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[<?php echo e($theme->theme_bg); ?>] after:bottom-[-6px] after:left-0">
                🔐 Forget Password
            </h1>

            <?php if(session('error')): ?>
                <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('success')): ?>
                <div class="mb-4 text-sm text-green-600 bg-green-50 border border-green-200 rounded p-3">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('customer.send-otp')); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>

                <!-- Email -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Email Address</label>
                    <div class="relative">
                        <i class="ri-mail-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="email" name="email" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition"
                            placeholder="Enter your email">
                    </div>
                </div>

                <!-- Submit -->
                <button type="submit"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                    <i class="ri-mail-send-line"></i>
                    Send OTP
                </button>
            </form>

            <!-- Footer -->
            <div class="mt-6 text-center text-sm text-gray-600">
                Remember password?
                <a href="<?php echo e(route('customer.login')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] font-medium hover:underline">
                    Login
                </a>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/customer/auth/forget.blade.php ENDPATH**/ ?>