
<?php $__env->startSection('title', 'Order by Products'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full mb-6">
        <!-- Header -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center pb-4 border-b rounded-md mb-4">
            <div class="flex flex-col gap-2 w-full md:w-2/3">
                <h1 class="text-xl font-bold text-gray-800">Order by Products</h1>
                <p class="text-sm text-gray-500 ml-1">Manage your order by products efficiently</p>
            </div>
        </div>

        <!-- Search & Filters -->
        <form method="GET" action="<?php echo e(route('admin.order.products')); ?>"
            class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-2 sm:gap-4">

            <div class="flex flex-col sm:flex-row w-full sm:w-2/3 gap-2">
                <!-- Search -->
                <div class="relative w-full sm:w-1/2">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search SKU"
                        class="w-full rounded-md bg-white text-gray-900 border border-gray-300 pl-10 pr-3 py-2 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200" />
                    <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-lg pointer-events-none">
                        <i class="ri-search-line"></i>
                    </span>
                </div>

                <!-- Category -->
                <select name="category_id" id="categoryFilter"
                    class="w-full sm:w-1/2 rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                    <option value="">-- All Categories --</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Subcategory -->
                <select name="subcategory_id" id="subcategoryFilter"
                    class="w-full sm:w-1/2 rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2.5 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                    <option value="">-- All Subcategories --</option>
                    <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subcategory->id); ?>"
                            <?php echo e(request('subcategory_id') == $subcategory->id ? 'selected' : ''); ?>>
                            <?php echo e($subcategory->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Search Button -->
                <button type="submit"
                    class="flex justify-center items-center px-4 py-2 h-10 rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] font-medium transition-all duration-150 mt-2 sm:mt-0">
                    <i class="ri-search-line mr-1"></i> Search
                </button>
            </div>

            <!-- Reset -->
            <a href="<?php echo e(route('admin.order.products')); ?>"
                class="flex justify-center items-center px-4 py-2 h-10 md:w-auto w-full rounded-md bg-gray-500 hover:bg-gray-600 text-white font-medium transition-all duration-150 mt-2 sm:mt-0">
                Reset
            </a>
        </form>

        <!-- Order by Table -->
        <div class="overflow-x-auto bg-white rounded-lg shadow">
            <table class="min-w-full table-auto border-collapse">
                <thead class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] text-sm font-semibold">
                    <tr>
                        <th class="px-4 py-3 text-center w-12">#</th>
                        <th class="px-4 py-3 text-left w-14">Image</th>
                        <th class="px-4 py-3 text-left">Name</th>
                        <th class="px-4 py-3 text-left">Category</th>
                        <th class="px-4 py-3 text-right w-40">Order by Serial</th>
                    </tr>
                </thead>
                <tbody class="text-sm text-gray-700 divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-2 text-center"><?php echo e($products->firstItem() + $index); ?></td>

                            <td class="px-4 py-2">
                                <?php if($product->images->first()): ?>
                                    <img src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                        class="w-10 h-10 rounded object-cover border">
                                <?php else: ?>
                                    <div
                                        class="w-10 h-10 bg-gray-200 flex items-center justify-center text-gray-500 text-xs rounded">
                                        N/A
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td class="px-4 py-2 font-medium"><?php echo e($product->name); ?></td>
                            <td class="px-4 py-2"><?php echo e($product->category->name ?? 'N/A'); ?></td>

                            <td class="px-4 py-2 text-right">
                                <form action="<?php echo e(route('admin.products.updateOrders')); ?>" method="POST"
                                    class="flex justify-end gap-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                    <input type="hidden" name="category_id" value="<?php echo e($product->category_id); ?>">

                                    <input type="number" name="orders[<?php echo e($product->id); ?>]"
                                        value="<?php echo e($product->orders); ?>" min="0" placeholder="Enter Serial"
                                        class="w-16 md:w-24 h-8 border border-gray-300 rounded px-2 py-1 text-sm focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] outline-none"
                                        required>

                                    <button type="submit"
                                        class="bg-green-500 hover:bg-green-600 text-white text-lg font-semibold px-3 py-1 h-8 rounded 
           relative group"
                                        title="Save">
                                        <i class="ri-save-3-line"></i>

                                        <span
                                            class="absolute bottom-12 left-1/2 -translate-x-1/2 scale-0 group-hover:scale-100 
               transition-all duration-200 bg-gray-800 text-white text-xs px-2 py-1 rounded shadow whitespace-nowrap">
                                            Save
                                        </span>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center py-6 text-gray-500">No products found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($products->hasPages()): ?>
            <div class="mt-4 flex justify-end gap-2">
                <?php if($products->onFirstPage()): ?>
                    <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed">Previous</span>
                <?php else: ?>
                    <a href="<?php echo e($products->previousPageUrl()); ?>"
                        class="px-4 py-2 rounded-md bg-white border border-gray-300 text-gray-700 hover:bg-gray-50">Previous</a>
                <?php endif; ?>

                <?php if($products->hasMorePages()): ?>
                    <a href="<?php echo e($products->nextPageUrl()); ?>"
                        class="px-4 py-2 rounded-md bg-white border border-gray-300 text-gray-700 hover:bg-gray-50">Next</a>
                <?php else: ?>
                    <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed">Next</span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/products/order_products.blade.php ENDPATH**/ ?>