
<?php $__env->startSection('title', 'Order Management'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full mb-6">
        <div class="mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-xl font-bold text-gray-700 flex items-center gap-2">
                <i class="ri-stack-line text-xl text-indigo-500"></i>
                Sales Report
            </h1>
            <nav class="text-sm text-gray-500 mt-2 sm:mt-0">
                <ol class="list-reset flex">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>" class="hover:underline">Dashboard</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li>Orders</li>
                </ol>
            </nav>
        </div>

        <form method="GET" action="<?php echo e(route('admin.orders.report')); ?>"
            class="bg-white p-4 rounded mb-2 flex flex-wrap gap-4 items-end">

            <div>
                <label class="text-sm text-gray-600">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>"
                    class="border rounded px-3 py-2 text-gray-700">
            </div>

            <div>
                <label class="text-sm text-gray-600">End Date</label>
                <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>"
                    class="border rounded px-3 py-2 text-gray-700">
            </div>

            <button type="submit" class="bg-indigo-600 text-white px-5 py-2 rounded hover:bg-indigo-700">
                Search
            </button>

        </form>
        
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">

            <div class="bg-white p-5 rounded shadow border-l-4 border-green-500">
                <h3 class="text-sm text-gray-500">Total Sale</h3>
                <p class="text-xl font-bold text-green-600">
                    ৳ <?php echo e(number_format($totalSell, 2)); ?>

                </p>
            </div>

            <div class="bg-white p-5 rounded shadow border-l-4 border-blue-500">
                <h3 class="text-sm text-gray-500">Total Buy</h3>
                <p class="text-xl font-bold text-blue-600">
                    ৳ <?php echo e(number_format($totalBuy, 2)); ?>

                </p>
            </div>

            <div class="bg-white p-5 rounded shadow border-l-4 border-indigo-500">
                <h3 class="text-sm text-gray-500">Profit</h3>
                <p class="text-xl font-bold <?php echo e($profit >= 0 ? 'text-indigo-600' : 'text-red-600'); ?>">
                    ৳ <?php echo e(number_format($profit, 2)); ?>

                </p>
            </div>
        </div>

        <div class="overflow-x-auto bg-white rounded shadow">
            <table class="min-w-full table-auto">
                <thead class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] text-sm font-semibold">
                    <tr>
                        <th class="px-4 py-3 text-left whitespace-nowrap">Invoice ID</th>
                        <th class="px-4 py-3 text-left whitespace-nowrap">Customer</th>
                        <th class="px-4 py-3 text-left whitespace-nowrap">Products</th>
                        <th class="px-4 py-3 text-center whitespace-nowrap">Costing</th>
                        <th class="px-4 py-3 text-center whitespace-nowrap">Sales</th>
                        <th class="px-4 py-3 text-center whitespace-nowrap">Profit</th>
                    </tr>
                </thead>
                <tbody class="text-sm text-gray-700 divide-y divide-gray-200">
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 transition-colors cursor-pointer"
                            onclick="const cb=this.querySelector('input[type=checkbox]'); cb.checked = !cb.checked; updateSelectedIds();">

                            <td class="px-4 py-3 text-left whitespace-nowrap font-medium text-gray-800">
                                <?php echo e($order->invoice_id); ?>

                            </td>

                            <td class="px-4 py-3 text-left whitespace-nowrap font-medium text-gray-800">
                                <div class="flex flex-col">
                                    <div class="flex flex-row gap-1">
                                        <strong class="text-gray-700">Name:</strong> <?php echo e($order->shipping->name); ?>

                                    </div>
                                    <div class="flex flex-row gap-1">
                                        <strong class="text-gray-700">Address:</strong>
                                        <?php echo e(\Illuminate\Support\Str::limit($order->shipping->address, 30, '...')); ?>

                                    </div>
                                </div>
                            </td>

                            <td class="px-4 py-3 text-left whitespace-nowrap font-medium text-gray-800">
                                <div class="flex flex-row items-center">
                                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->product_image): ?>
                                            <img src="<?php echo e($item->product_image); ?>" alt="Product Image"
                                                class="w-12 h-12 object-cover rounded-full border border-gray-200 -mr-[10px]"
                                                onclick="window.open('<?php echo e($item->product_image); ?>', '_blank')">
                                        <?php else: ?>
                                            <div
                                                class="w-10 h-10 rounded bg-gray-200 flex items-center justify-center text-gray-500 text-sm -mr-[5px]">
                                                N/A
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </td>

                            <td class="px-4 py-3 text-center">
                                ৳<?php echo e(number_format($order->order_buy, 2)); ?>

                            </td>

                            <td class="px-4 py-3 text-center">
                                ৳<?php echo e(number_format($order->order_sell, 2)); ?>

                            </td>

                            <td
                                class="px-4 py-3 text-center <?php echo e($order->order_profit >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                ৳<?php echo e(number_format($order->order_profit, 2)); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($orders->isEmpty()): ?>
                        <tr>
                            <td colspan="8" class="py-4 px-3 text-center text-gray-400">No orders found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/order/report.blade.php ENDPATH**/ ?>