
<?php $__env->startSection('title', 'Courier Gateway API'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Courier Gateway API</h2>
                <a href="<?php echo e(route('admin.courier.index')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-sm font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a> /
                    Courier / Create
                </p>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-base font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
        </div>

        <!-- Forms -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Redx -->
                <div class="border border-gray-300 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3" style="background-color: #E0002D;">
                        <span class="text-white text-xl font-semibold">Redx</span>
                        <i class="ri-motorbike-fill text-3xl"></i>
                    </div>

                    <form action="<?php echo e(route('admin.courier.store')); ?>" method="POST" enctype="multipart/form-data"
                        class="grid grid-cols-1 gap-3 px-4 py-4">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="type" id="redx" value="redx">

                        <?php $__currentLoopData = ['Client Id' => 'api_key', 'Client Secret' => 'secret_key', 'Base URL' => 'url', 'Token' => 'token']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div>
                                <label class="block text-md text-gray-600 mb-1 font-medium"><?php echo e($label); ?></label>
                                <input type="<?php echo e($name === 'url' ? 'url' : 'text'); ?>" name="<?php echo e($name); ?>"
                                    placeholder="Enter <?php echo e($label); ?>" value="<?php echo e(old($name, $redx?->$name)); ?>"
                                    class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2 focus:ring-2 focus:ring-[#E0002D] outline-none transition-all">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- Toggle -->
                        <div class="flex items-center justify-between">
                            <label class="text-gray-700 font-medium">Enable Redx</label>
                            <input type="checkbox" name="status" <?php echo e(isset($redx) && $redx->status ? 'checked' : ''); ?>

                                class="toggle-checkbox h-5 w-10 rounded-full bg-gray-300 checked:bg-[#E0002D] transition duration-200">
                        </div>

                        <div class="mt-3">
                            <button type="submit"
                                class="w-full rounded-md bg-[#E0002D] hover:bg-[#c10025] text-white py-2.5 font-medium transition-all">
                                Save
                            </button>
                        </div>
                    </form>
                </div>

                <!-- STEADFAST -->
                <div class="border border-gray-300 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3" style="background-color: #10B981;">
                        <span class="text-white text-xl font-semibold">Steadfast</span>
                        <i class="ri-truck-fill text-3xl"></i>
                    </div>

                    <form action="<?php echo e(route('admin.courier.store')); ?>" method="POST" enctype="multipart/form-data"
                        class="grid grid-cols-1 gap-3 px-4 py-4">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="type" id="steadfast" value="steadfast">

                        <?php $__currentLoopData = ['API Key' => 'api_key', 'Secret Key' => 'secret_key', 'Base URL' => 'url', 'Token' => 'token']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div>
                                <label class="block text-md text-gray-600 mb-1 font-medium"><?php echo e($label); ?></label>
                                <input type="<?php echo e($name === 'url' ? 'url' : 'text'); ?>" name="<?php echo e($name); ?>"
                                    placeholder="Enter <?php echo e($label); ?>" value="<?php echo e(old($name, $steadfast?->$name)); ?>"
                                    class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2 focus:ring-2 focus:ring-emerald-500 outline-none transition-all">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- Toggle -->
                        <div class="flex items-center justify-between">
                            <label class="text-gray-700 font-medium">Enable Steadfast</label>
                            <input type="checkbox" name="status"
                                <?php echo e(isset($steadfast) && $steadfast->status ? 'checked' : ''); ?>

                                class="toggle-checkbox h-5 w-10 rounded-full bg-gray-300 checked:bg-[#10B981] transition duration-200">
                        </div>

                        <div class="mt-3">
                            <button type="submit"
                                class="w-full rounded-md bg-emerald-600 hover:bg-emerald-700 text-white py-2.5 font-medium transition-all">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="mt-6 w-full">
                <div class="border border-gray-300 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3" style="background-color: #4F46E5;">
                        <span class="text-white text-xl font-semibold">BD Courier Api</span>
                        <i class="ri-shield-check-fill text-3xl text-white"></i>
                    </div>

                    <form action="<?php echo e(route('admin.fraud.store')); ?>" method="POST" enctype="multipart/form-data"
                        class="grid grid-cols-1 gap-3 px-4 py-4">
                        <?php echo csrf_field(); ?>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">API Key</label>
                            <input type="text" placeholder="Enter BD Courier Api"
                                value="<?php echo e(old('fraud_api', $setting->fraud_api)); ?>" name="fraud_api"
                                class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2 
            focus:ring-2 focus:ring-indigo-500 outline-none transition-all">
                        </div>

                        <div class="mt-3">
                            <button type="submit"
                                class="w-full rounded-md bg-indigo-600 hover:bg-indigo-700 text-white py-2.5 font-medium transition-all">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/backend/courier/index.blade.php ENDPATH**/ ?>