
<?php $__env->startSection('title', 'Verify OTP'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-center">

        <div class="hidden lg:flex flex-col justify-center bg-white shadow rounded-lg p-8 h-[-webkit-fill-available]">
            <h2 class="text-3xl font-semibold text-gray-800 mb-4">Verify OTP 🔑</h2>
            <p class="text-gray-600 mb-6">
                Enter the 6-digit OTP sent to your email to reset your password.
            </p>
        </div>

        <div class="bg-white shadow rounded-lg p-6 md:p-8">

            <h1 class="text-2xl font-medium mb-6 text-gray-800 relative inline-block 
                       after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[<?php echo e($theme->theme_bg); ?>] after:bottom-[-6px] after:left-0">
                🔐 Verify OTP
            </h1>

            <?php if($errors->any()): ?>
                <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                    <?php echo e($errors->first()); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('customer.verify-otp.post')); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>

                <input type="hidden" name="email" value="<?php echo e(session('email')); ?>">

                <!-- OTP -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">OTP Code</label>
                    <div class="relative">
                        <i class="ri-key-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="text" name="otp" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition"
                            placeholder="Enter 6-digit OTP">
                    </div>
                </div>

                <button type="submit"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                    <i class="ri-check-line"></i>
                    Verify OTP
                </button>
            </form>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/customer/auth/otp.blade.php ENDPATH**/ ?>