
<?php $__env->startSection('title', 'Customer Management'); ?>
<?php $__env->startSection('content'); ?>
<div class="w-full mb-6">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center pb-4 border-b rounded-md mb-4">
        <div class="flex flex-col gap-2 w-full md:w-2/3">
            <h1 class="text-xl font-bold text-gray-800">Customer Management</h1>
            <p class="text-sm text-gray-500 ml-1">Manage all registered customers efficiently</p>
        </div>
    </div>

    <form method="GET" action="<?php echo e(route('admin.customer.index')); ?>" class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-2 sm:gap-4">
        <div class="flex flex-col sm:flex-row w-full sm:w-2/3 gap-2">
            <div class="relative w-full sm:w-1/2">
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search by name, email or phone..."
                    class="w-full rounded-md bg-white text-gray-900 border border-gray-300 pl-10 pr-3 py-2 text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200" />
                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 text-lg pointer-events-none">
                    <i class="ri-search-line"></i>
                </span>
            </div>
            <button type="submit" class="flex justify-center items-center px-4 py-2 h-10 rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:opacity-90 font-medium transition-all duration-150 mt-2 sm:mt-0">
                <i class="ri-search-line mr-1"></i> Search
            </button>
        </div>
        <a href="<?php echo e(route('admin.customer.index')); ?>" class="flex justify-center items-center px-4 py-2 h-10 md:w-auto w-full rounded-md bg-gray-500 hover:bg-gray-600 text-white font-medium transition-all duration-150 mt-2 sm:mt-0">
            Reset
        </a>
    </form>

    <div class="overflow-x-auto bg-white rounded shadow">
        <table class="min-w-full table-auto">
            <thead class="bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] text-sm font-semibold">
                <tr>
                    <th class="px-4 py-3 text-center">#</th>
                    <th class="px-4 py-3 text-left whitespace-nowrap">Customer Name</th>
                    <th class="px-4 py-3 text-left whitespace-nowrap">Phone Number</th>
                    <th class="px-4 py-3 text-left whitespace-nowrap">Email Address</th>
                    <th class="px-4 py-3 text-center">Status</th>
                    <th class="px-4 py-3 text-center whitespace-nowrap">Registered At</th>
                    <th class="px-4 py-3 text-right pr-8">Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm text-gray-700 divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-4 py-3 text-center"><?php echo e($customers->firstItem() + $index); ?></td>
                    <td class="px-4 py-3 font-medium text-gray-900"><?php echo e($data->name); ?></td>
                    <td class="px-4 py-3"><?php echo e($data->phone ?? 'N/A'); ?></td>
                    <td class="px-4 py-3"><?php echo e($data->email ?? 'N/A'); ?></td>
                    <td class="px-4 py-3 text-center">
                        <?php if($data->status == 'active'): ?>
                            <span class="px-2 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>
                        <?php else: ?>
                            <span class="px-2 py-1 bg-red-100 text-red-700 rounded-full text-xs font-semibold">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-4 py-3 text-center"><?php echo e($data->created_at->format('d M, Y')); ?></td>
                    <td class="px-4 py-3 text-right">
                        <div class="flex justify-end gap-2">
                            <form action="<?php echo e(route('admin.customer.status', $data->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php if($data->status == 'active'): ?>
                                    <button type="submit" class="inline-flex items-center px-3 py-1 bg-amber-500 hover:bg-amber-600 text-white rounded shadow text-sm transition-all">
                                        <i class="ri-close-circle-line mr-1"></i> Inactive
                                    </button>
                                <?php else: ?>
                                    <button type="submit" class="inline-flex items-center px-3 py-1 bg-emerald-500 hover:bg-emerald-600 text-white rounded shadow text-sm transition-all">
                                        <i class="ri-checkbox-circle-line mr-1"></i> Active
                                    </button>
                                <?php endif; ?>
                            </form>
                            <form action="<?php echo e(route('admin.customer.destroy', $data->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this customer?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="inline-flex items-center justify-center px-3 py-1 bg-red-500 hover:bg-red-600 text-white rounded shadow text-sm transition-all">
                                    <i class="ri-delete-bin-6-line mr-1"></i> Delete
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="py-10 px-3 text-center text-gray-400">
                        <div class="flex flex-col items-center">
                            <i class="ri-user-unfollow-line text-4xl mb-2"></i>
                            <span>No customers found in the system.</span>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($customers->hasPages()): ?>
    <div class="mt-4 flex justify-end gap-2">
        <?php if($customers->onFirstPage()): ?>
            <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed text-sm">Previous</span>
        <?php else: ?>
            <a href="<?php echo e($customers->previousPageUrl()); ?>" class="px-4 py-2 rounded-md bg-white border border-gray-300 text-gray-700 hover:bg-gray-50 text-sm">Previous</a>
        <?php endif; ?>

        <?php if($customers->hasMorePages()): ?>
            <a href="<?php echo e($customers->nextPageUrl()); ?>" class="px-4 py-2 rounded-md bg-white border border-gray-300 text-gray-700 hover:bg-gray-50 text-sm">Next</a>
        <?php else: ?>
            <span class="px-4 py-2 rounded-md bg-gray-100 text-gray-500 cursor-not-allowed text-sm">Next</span>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/allbdinc/public_html/resources/views/backend/customer/index.blade.php ENDPATH**/ ?>