<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo e($setting->name); ?></title>
    <?php
        $favicon = $setting->favicon;
        $logo = $setting->icon;
    ?>
    <?php if($favicon && file_exists(public_path($favicon))): ?>
        <link rel="icon" href="<?php echo e(asset('public/' . $favicon)); ?>" type="image/png">
    <?php endif; ?> <!-- fot awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/all.css')); ?>" />
    <!-- core css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/backEnd/assets/css/toastr.min.css')); ?>" />
    <!-- owl carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/owl.theme.default.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/owl.carousel.min.css')); ?>" />
    <!-- owl carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css/responsive.css')); ?>" />
    <?php if(!empty($pixelTracking)): ?>
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($pixelTracking); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($pixelTracking); ?>&ev=PageView&noscript=1" />
        </noscript>
    <?php endif; ?>

    <meta name="app-url" content="<?php echo e(route('campaign', $campaign->campaign_slug)); ?>" />
    <meta name="robots" content="index, follow" />
    <meta name="description" content="<?php echo e($campaign->short_description); ?>" />
    <meta name="keywords" content="<?php echo e($campaign->campaign_slug); ?>" />

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product" />
    <meta name="twitter:site" content="<?php echo e($campaign->name); ?>" />
    <meta name="twitter:title" content="<?php echo e($campaign->name); ?>" />
    <meta name="twitter:description" content="<?php echo e($campaign->short_description); ?>" />
    <meta name="twitter:creator" content="" />
    <meta property="og:url" content="<?php echo e(route('campaign', $campaign->campaign_slug)); ?>" />
    <meta name="twitter:image" content="<?php echo e(asset('public/' . $campaign->banner)); ?>" />

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($campaign->name); ?>" />
    <meta property="og:type" content="product" />
    <meta property="og:url" content="<?php echo e(route('campaign', $campaign->campaign_slug)); ?>" />
    <meta property="og:image" content="<?php echo e(asset('public/' .$campaign->banner)); ?>" />
    <meta property="og:description" content="<?php echo e($campaign->short_description); ?>" />
    <meta property="og:site_name" content="<?php echo e($campaign->name); ?>" />
</head>

<style>
    .selected {
        border: 2px solid green;
    }

    .countdown-container {
        text-align: center;
    }

    .counter-card {
        border: 2px dotted white;
        border-radius: 15px;
        padding: 5px;
        background-color: transparent;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .counter-card div {
        font-size: 1.2em;
        font-weight: bolder;
        color: white;
    }

    .counter-card span {
        display: block;
        font-size: 0.8em;
        color: orange;
    }

    @keyframes colorAnimation {
        0% {
            color: pink;
        }
        33% {
            color: green;
        }
        66% {
            color: red;
        }
        100% {
            color: pink;
        }
    }

    .animated-heading {
        font-size: 2em;
        font-weight: bold;
        animation: colorAnimation 3s linear infinite;
    }

    .form_inn {
        padding: 10px;
    }

    @media (max-width: 992px) {
        .campro_inn,
        .cont_inner,
        .cont_num,
        .discount_inn {
            padding: 10px !important;
            width: 100%;
        }

        .discount_inn {
            margin: 10px 0 0 0;
        }

        .campro_inn h2 {
            font-size: 20px;
        }
    }
</style>

<style>
    .button-3d {
        position: relative;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .button-3d:hover {
        transform: scale(1.05);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    }
</style>

<style>
    .button-animated-border {
        position: relative;
        overflow: hidden;
        border: 3px solid white;
        border-radius: 10px;
        transition: color 0.3s ease;
        animation: border-animation 3s linear infinite;
    }

    @keyframes border-animation {
        0% {
            border-color: white;
            transform: scale(0.95);
        }
        25% {
            border-color: yellow;
            transform: scale(1);
        }
        50% {
            border-color: white;
            transform: scale(0.95);
        }
        75% {
            border-color: yellow;
            transform: scale(1);
        }
        100% {
            border-color: white;
            transform: scale(0.95);
        }
    }

    .button-animated-border:hover {
        color: #fff;
    }
</style>

<body>
    
        <section style="background-image: radial-gradient(at center center, #139525 28%, #0E320F 79%)">
        <div class="container py-2 py-md-4">
            <div class="row gy-2">

            <div class="col-md-7">
                <?php
                   $parts = explode('|', $campaign->offer_title);
                ?>

                <h4 class="text-light text-center py-2 py-md-4 fw-bolder">
                  <?php echo e($parts[0] ?? ''); ?>

                       <span class="text-warning"><?php echo e($parts[1] ?? ''); ?></span>
                </h4>
            </div>
            
            <input type="hidden" id="offer_date" value="<?php echo e($campaign->offer_date); ?>">

                <div class="col-md-5">
                    <div class="countdown-container">
                        <div class="countdown" id="countdown">
                            <div class="row g-1">

                                <div class="col-3">
                                    <div class="counter-card">
                                        <div id="days"></div>
                                        <span>Days</span>
                                    </div>
                                </div>

                                <div class="col-3">
                                    <div class="counter-card">
                                        <div id="hours"></div>
                                        <span>Hours</span>
                                    </div>
                                </div>

                                <div class="col-3">
                                    <div class="counter-card">
                                        <div id="minutes"></div>
                                        <span>Minutes</span>
                                    </div>
                                </div>

                                <div class="col-3">
                                    <div class="counter-card">
                                        <div id="seconds"></div>
                                        <span>Seconds</span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    
    <section class="banner-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-sm-10">
                    <div class="campaign_banner">
                        <div class="banner_title">
                            <h2><?php echo e($campaign->name); ?></h2>
                        </div>
                        <div class="banner-image-wrapper">
                            <div class="banner-slider owl-carousel">
                                <?php $__currentLoopData = json_decode($campaign->banner_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="banner-image">
                                        <img src="<?php echo e(asset('public/' .$banner)); ?>" alt="">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- banner section end -->

    <!-- short-desctiption section start -->
    <section class="short-des">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-sm-8">
                    <div class="short-des-title">
                        <?php echo $campaign->campaign_description; ?>

                    </div>
                    <div class="ord_btn">
                        <a href="#order_form" class="order_place"> অর্ডার করুন
                            <i class="fa-solid fa-arrow-down"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- short-desctiption section end -->

    <!-- desctiption section start -->
    <section class="description-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="description-inner">
                        <div class="description-title">
                            <h2><?php echo e($campaign->description_title); ?></h2>
                        </div>
                        <div class="main-description">
                            <?php echo $campaign->description; ?>

                        </div>
                    </div>
                    <div class="ord_btn mt-5">
                        <a href="#order_form" class="order_place"> অর্ডার করুন
                            <i class="fa-solid fa-arrow-down"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- desctiption section end -->

    <!-- desctiption section start -->
    <section class="whychoose-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="whychoose-inner">
                        <div class="whychoose-title">
                            <h2>আমাদের প্রোডাক্ট কোনো কিনবেন?</h2>
                        </div>
                        <div class="main-whychoose">
                            <?php echo $campaign->why_buy_from_us; ?>

                        </div>
                    </div>
                    <div class="ord_btn my-5">
                        <a href="#order_form" class="order_place"> অর্ডার করুন
                            <i class="fa-solid fa-arrow-down"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- desctiption section end -->

    <!-- review section start -->
    <?php
        $reviews = json_decode($campaign->review_image, true);
    ?>

    <?php if($reviews && count($reviews) > 0): ?>
        <section class="review-section">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="rev_inn">
                            <div class="rev_title">
                                <h2>আমাদের কাস্টমারের রিভিউ?</h2>
                            </div>
                            <div class="review_slider owl-carousel">
                                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="review_item">
                                        <img src="<?php echo e(asset('public/' . $banner)); ?>" alt="">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- review section end -->

    <!-- offer price form end -->
    <section class="price-section">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="offer_price">
                        <div class="offer_title">
                            <h2>অফারটি সীমিত সময়ের জন্য, তাই অফার শেষ হওয়ার আগেই অর্ডার করুন</h2>
                        </div>
                        <div class="product-price">
                            <h2>
                                <?php if($product->old_price): ?>
                                    <p class="old_price"> আগের দাম : <del> <?php echo e($product->old_price); ?></del> /=</p>
                                <?php endif; ?>
                                <p>বর্তমান দাম <?php echo e($product->new_price); ?>/=</p>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="form_sec">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form_inn">
                        <form action="<?php echo e(route('order.create')); ?>" method="POST" class="col-sm-12">
                            <div class="row order_by">
                                <div class="col-sm-5">
                                    <div class="checkout-shipping" id="order_form">
                                        <div data-parsley-validate="">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="product[id]" value="<?php echo e($product->id); ?>">
                                            <input type="hidden" name="product[name]" value="<?php echo e($product->name); ?>">
                                            <input type="hidden" name="product[price]"
                                                value="<?php echo e($product->new_price); ?>">
                                            <input type="hidden" name="product[image]"
                                                value="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>">
                                            <input type="hidden" name="variant_id" id="variant_id" value=""
                                                class="variant_id">
                                            <input type="hidden" name="incomplete" id="orderId" value=""
                                                class="incomplete-flag">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5 class="potro_font">👇 অর্ডারটি কনফার্ম করতে আপনার ইনফরমেশন দিন
                                                    </h5>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-sm-12">
                                                            <div class="form-group mb-3">
                                                                <label for="name">আপনার নাম লিখুন * </label>
                                                                <input type="text" id="name"
                                                                    class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="name" value="<?php echo e(old('name')); ?>"
                                                                    required>
                                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($message); ?></strong>
                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                        <!-- col-end -->
                                                        <div class="col-sm-12">
                                                            <div class="form-group mb-3">
                                                                <label for="phone">আপনার মোবাইল লিখুন *</label>
                                                                <input type="number" minlength="11" id="number"
                                                                    maxlength="11" pattern="0[0-9]+"
                                                                    title="please enter number only and 0 must first character"
                                                                    title="Please enter an 11-digit number."
                                                                    id="phone"
                                                                    class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="phone" value="<?php echo e(old('phone')); ?>"
                                                                    required>
                                                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($message); ?></strong>
                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                        <!-- col-end -->
                                                        <div class="col-sm-12">
                                                            <div class="form-group mb-3">
                                                                <label for="address">আপনার ঠিকানা লিখুন *</label>
                                                                <input type="address" id="address"
                                                                    class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="address" value="<?php echo e(old('address')); ?>"
                                                                    required>
                                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($message); ?></strong>
                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12">
                                                            <div class="form-group mb-3">
                                                                <label for="area">আপনার এরিয়া সিলেক্ট করুন
                                                                    *</label>
                                                                <select class="form-control" name="area"
                                                                    id="area" required>
                                                                    <option value="<?php echo e($inDhakaCharge); ?>">Inside Dhaka
                                                                        <?php echo e($inDhakaCharge); ?>

                                                                    </option>
                                                                    <option value="<?php echo e($outDhakaCharge); ?>">Outside
                                                                        Dhaka <?php echo e($outDhakaCharge); ?></option>
                                                                </select>
                                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($message); ?></strong>
                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12">
                                                            <div class="form-group">
                                                                <button style="width: -webkit-fill-available;"
                                                                    class="order_place confirm_order"
                                                                    type="submit">অর্ডার কন্ফার্ম করুন </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- card end -->
                                        </div>
                                    </div>
                                </div>
                                <!-- col end -->
                                <div class="col-sm-7 cust-order-1">
                                    <div class="cart_details">
                                        <div class="card">
                                            <div class="card-header">
                                                <h5 class="potro_font">পণ্যের বিবরণ </h5>
                                            </div>
                                            <div class="card-body cartlist  table-responsive">
                                                <table
                                                    class="cart_table table table-bordered table-striped text-center mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th style="width: 60%;">প্রোডাক্ট</th>
                                                            <th style="width: 20%;">পরিমাণ</th>
                                                            <th style="width: 20%;">মূল্য</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        <tr>
                                                            <td class="text-left" style="align-content: center;">
                                                                <a style="font-size: 14px;" href="#"><img
                                                                        style="border-radius: 5px; margin-right: 5px;"
                                                                        src="<?php echo e(asset('public/uploads/products/' . $product->images->first()->image)); ?>"
                                                                        height="50" width="50">
                                                                    <?php echo e(Str::limit($product->name, 20)); ?></a>
                                                            </td>
                                                            <td width="15%" class="cart_qty"
                                                                style="align-content: center;">
                                                                <div class="qty-cart vcart-qty">
                                                                    <div class="quantity">
                                                                        <button class="minus cart_decrement"
                                                                            data-id="<?php echo e($product->id); ?>">-</button>
                                                                        <input type="text" value="1"
                                                                            name="product[quantity]" readonly />
                                                                        <button class="plus  cart_increment"
                                                                            data-id="<?php echo e($product->id); ?>">+</button>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td style="align-content: center;">
                                                                ৳<?php echo e($product->new_price); ?>

                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                    <tfoot>
                                                        <tr>
                                                            <th colspan="2" class="text-end px-4">মোট</th>
                                                            <td>
                                                                <span id="net_total"><span class="alinur">৳
                                                                    </span><strong><?php echo e($product->new_price); ?></strong></span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th colspan="2" class="text-end px-4">ডেলিভারি চার্জ
                                                            </th>
                                                            <td>
                                                                <span id="cart_shipping_cost"><span class="alinur">৳
                                                                    </span><strong><?php echo e($inDhakaCharge); ?></strong></span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th colspan="2" class="text-end px-4">সর্বমোট</th>
                                                            <td>
                                                                <span id="grand_total"><span
                                                                        class="alinur">৳</span><strong><?php echo e($product->new_price + $inDhakaCharge); ?></strong></span>
                                                            </td>
                                                        </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- col end -->
                        </form>
                    </div>
                </div>

            </div>
        </div>
        </div>
    </section>
    
    <script>
    function startCountdown() {
        const offerDate = document.getElementById('offer_date').value;

        // Convert offer date to JS date format
        const targetDate = new Date(offerDate).getTime();

        setInterval(function () {
            const now = new Date().getTime();
            const diff = targetDate - now;

            if (diff <= 0) {
                document.getElementById('days').innerHTML = 0;
                document.getElementById('hours').innerHTML = 0;
                document.getElementById('minutes').innerHTML = 0;
                document.getElementById('seconds').innerHTML = 0;
                return;
            }

            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            document.getElementById('days').innerHTML = days;
            document.getElementById('hours').innerHTML = hours;
            document.getElementById('minutes').innerHTML = minutes;
            document.getElementById('seconds').innerHTML = seconds;

        }, 1000);
    }

    // Start the countdown
    startCountdown();
</script>


    <script src="<?php echo e(asset('public/frontEnd/campaign/js/jquery-2.1.4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js/all.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js/script.js')); ?>"></script>
    <script src="<?php echo e(asset('public/backEnd/assets/js/toastr.min.js')); ?>"></script>

    <script>
        const productsFromBackend = [<?php echo json_encode($product, 15, 512) ?>];

        document.addEventListener("DOMContentLoaded", function() {
            const formFields = document.querySelectorAll(
                "input[name='name'], input[name='phone'], textarea[name='address'], select[name='area']"
            );

            let ajaxTimeout;

            function getProductData() {
                const productInputs = document.querySelectorAll("input[name^='product']");
                let productObj = {};

                productInputs.forEach(input => {
                    const match = input.name.match(/product\[(.+)\]/);
                    if (match) {
                        productObj[match[1]] = input.value;
                    }
                });

                return [productObj];
            }

            function sendAjax() {
                const data = {
                    _token: '<?php echo e(csrf_token()); ?>',
                    name: document.querySelector("input[name='name']").value.trim(),
                    phone: document.querySelector("input[name='phone']").value.trim(),
                    address: document.querySelector("input[name='address']").value.trim(),
                    charge: document.querySelector("select[name='area']").value,
                    products: getProductData()
                };

                fetch('/order/incomplete', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': data._token
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.status === 'success' && result.order_id) {
                            const orderId = document.getElementById('orderId');
                            if (orderId) orderId.value = result.order_id;
                        }
                    })
                    .catch(error => {
                        console.error('AJAX Error:', error);
                    });
            }

            function checkFields() {
                let allFilled = true;

                formFields.forEach(field => {
                    if (!field.value.trim()) {
                        allFilled = false;
                    }
                });

                if (allFilled) {
                    if (ajaxTimeout) clearTimeout(ajaxTimeout);
                    ajaxTimeout = setTimeout(sendAjax, 2000);
                } else {
                    if (ajaxTimeout) clearTimeout(ajaxTimeout);
                }
            }

            formFields.forEach(field => {
                field.addEventListener("input", checkFields);
                field.addEventListener("change", checkFields);
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            function updateGrandTotal() {
                let quantity = parseInt($('.quantity input').val()) || 1;
                let productPrice = parseFloat(<?php echo e($product->new_price); ?>);
                let shipping = parseFloat($('#cart_shipping_cost strong').text());
                let total = (productPrice * quantity) + shipping;

                $('#net_total strong').text(productPrice * quantity);
                $('#grand_total strong').text(total);
            }

            // initial load
            updateGrandTotal();

            // increment button
            $('.cart_increment').click(function() {
                let input = $(this).siblings('input');
                let val = parseInt(input.val());
                input.val(val + 1);
                updateGrandTotal();
            });

            // decrement button
            $('.cart_decrement').click(function() {
                let input = $(this).siblings('input');
                let val = parseInt(input.val());
                if (val > 1) {
                    input.val(val - 1);
                    updateGrandTotal();
                }
            });

            // shipping change
            $('#area').change(function() {
                let selectedShipping = parseFloat($(this).val());
                $('#cart_shipping_cost strong').text(selectedShipping);
                updateGrandTotal();
            });
        });
    </script>

    <!-- bootstrap js -->
    <script>
        $(document).ready(function() {
            $(".owl-carousel").owlCarousel({
                margin: 15,
                loop: true,
                dots: false,
                autoplay: true,
                autoplayTimeout: 6000,
                autoplayHoverPause: true,
                items: 1,
            });
            $('.owl-nav').remove();
        });
    </script>
    <script>
        $(document).ready(function() {
            $(".main_slider").owlCarousel({
                items: 1,
                loop: true,
                dots: false,
                autoplay: true,
                nav: false,
                autoplayHoverPause: false,
                margin: 0,
                mouseDrag: true,
                smartSpeed: 1000,
                autoplayTimeout: 4000

            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <script>
        $('.review_slider').owlCarousel({
            dots: false,
            arrow: false,
            autoplay: true,
            loop: true,
            margin: 10,
            smartSpeed: 1000,
            mouseDrag: true,
            touchDrag: true,
            items: 6,
            responsiveClass: true,
            responsive: {
                300: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                768: {
                    items: 5,
                },
                1170: {
                    items: 5,
                },
            }
        });
    </script>
</body>

</html>
<?php /**PATH /home/mojibor1/public_html/resources/views/frontend/campaign/campaign.blade.php ENDPATH**/ ?>