<?php $__env->startSection('title', 'My Orders'); ?>
<?php $__env->startSection('content'); ?>
<div class="bg-[#f8fafc] min-h-screen py-10 md:py-16">
    <div class="max-w-6xl mx-auto px-4">
        
        <div class="flex flex-col md:flex-row md:items-center justify-between mb-10 gap-4">
            <div>
                <h1 class="text-3xl font-black text-gray-900 tracking-tight flex items-center gap-3">
                    <span class="w-2 h-10 bg-[<?php echo e($theme->theme_bg); ?>] rounded-full"></span>
                    My Orders
                </h1>
                <p class="text-gray-500 font-medium mt-1 ml-5">Track and manage your recent purchases</p>
            </div>
            
<a href="<?php echo e(route('shop')); ?>" 
   onmouseover="this.style.backgroundColor='<?php echo e($theme->theme_bg); ?>'; this.style.color='white'; this.style.borderColor='<?php echo e($theme->theme_bg); ?>';" 
   onmouseout="this.style.backgroundColor='white'; this.style.color='#374151'; this.style.borderColor='#e5e7eb';"
   class="inline-flex items-center justify-center gap-2 px-6 py-3 bg-white border border-gray-200 text-gray-700 font-bold rounded-2xl transition-all shadow-sm">
    <i class="ri-shopping-bag-line"></i> Continue Shopping
</a>
        </div>

        <?php if($orders->count() > 0): ?>
            <div class="bg-white rounded-xl shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-separate border-spacing-0">
                        <thead>
                            <tr class="bg-gray-50/50">
                                <th class="px-8 py-5 text-[11px] font-black text-gray-400 uppercase tracking-[2px] border-b border-gray-100">Invoice ID</th>
                                <th class="px-8 py-5 text-[11px] font-black text-gray-400 uppercase tracking-[2px] border-b border-gray-100">Date</th>
                                <th class="px-8 py-5 text-[11px] font-black text-gray-400 uppercase tracking-[2px] border-b border-gray-100">Status</th>
                                <th class="px-8 py-5 text-[11px] font-black text-gray-400 uppercase tracking-[2px] border-b border-gray-100">Total Amount</th>
                                <th class="px-8 py-5 text-[11px] font-black text-gray-400 uppercase tracking-[2px] border-b border-gray-100 text-right">Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="group hover:bg-gray-50/80 transition-all duration-300">
                                    <td class="px-8 py-6">
                                        <span class="font-black text-gray-900 tracking-tight text-lg">#<?php echo e($order->invoice_id); ?></span>
                                    </td>
                                    <td class="px-8 py-6">
                                        <div class="flex flex-col">
                                            <span class="text-gray-800 font-bold text-nowrap"><?php echo e($order->created_at->format('d M, Y')); ?></span>
                                            <span class="text-[10px] text-gray-400 font-medium uppercase tracking-tighter text-nowrap"><?php echo e($order->created_at->format('h:i A')); ?></span>
                                        </div>
                                    </td>
                                    <td class="px-8 py-6">
                                        <?php
                                            $statusConfig = [
                                                'pending'   => ['bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'icon' => 'ri-time-line'],
                                                'confirmed' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-700', 'icon' => 'ri-checkbox-circle-line'],
                                                'shipped'   => ['bg' => 'bg-indigo-100', 'text' => 'text-indigo-700', 'icon' => 'ri-truck-line'],
                                                'delivered' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'icon' => 'ri-checkbox-double-line'],
                                                'cancelled' => ['bg' => 'bg-red-100', 'text' => 'text-red-700', 'icon' => 'ri-close-circle-line'],
                                            ];
                                            $status = $statusConfig[$order->order_status] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-700', 'icon' => 'ri-loader-4-line'];
                                        ?>
                                        <span class="inline-flex items-center gap-1.5 px-3 py-1.5 <?php echo e($status['bg']); ?> <?php echo e($status['text']); ?> rounded-xl text-xs font-black uppercase tracking-wider">
                                            <i class="<?php echo e($status['icon']); ?> text-sm"></i>
                                            <?php echo e($order->order_status); ?>

                                        </span>
                                    </td>
                                    <td class="px-8 py-6">
                                        <span class="text-xl font-black text-gray-900 tracking-tight">৳<?php echo e(number_format($order->total, 2)); ?></span>
                                    </td>
                                    <td class="px-8 py-6 text-right">
                                        <a href="<?php echo e(route('customer.order.view', $order->id)); ?>" 
                                           class="inline-flex items-center gap-2 px-5 py-2.5 bg-gray-900 text-white text-xs font-black uppercase tracking-widest rounded-xl hover:bg-[<?php echo e($theme->theme_bg); ?>] transition-all duration-300 shadow-lg shadow-gray-200 hover:shadow-[<?php echo e($theme->theme_bg); ?>]/20">
                                            <i class="ri-eye-line text-sm"></i> Details
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-[3rem] p-16 shadow-[0_20px_50px_rgba(0,0,0,0.02)] border border-gray-100 text-center">
                <div class="relative inline-block mb-8">
                    <div class="absolute inset-0 bg-[<?php echo e($theme->theme_bg); ?>] opacity-10 blur-3xl rounded-full"></div>
                    <img src="https://cdn-icons-png.flaticon.com/512/2038/2038854.png" alt="No Orders"
                        class="relative w-48 h-48 mx-auto animate-float">
                </div>
                <h2 class="text-3xl font-black text-gray-900 tracking-tight mb-4">No Orders Found</h2>
                <p class="text-gray-500 font-medium max-w-sm mx-auto mb-10 leading-relaxed">
                    It looks like you haven't discovered our amazing products yet. Your future orders will appear here!
                </p>
                <a href="<?php echo e(route('shop')); ?>"
                    class="inline-flex items-center gap-3 bg-gray-900 text-white font-black py-5 px-10 rounded-2xl hover:bg-[<?php echo e($theme->theme_bg); ?>] transition-all duration-300 shadow-2xl uppercase tracking-[2px] text-xs">
                    Start Your Shopping Journey <i class="ri-arrow-right-line"></i>
                </a>
            </div>
        <?php endif; ?>

    </div>
</div>

<style>
    @keyframes float {
        0% { transform: translateY(0px); }
        50% { transform: translateY(-15px); }
        100% { transform: translateY(0px); }
    }
    .animate-float {
        animation: float 4s ease-in-out infinite;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/customer/order.blade.php ENDPATH**/ ?>