
<?php $__env->startSection('title', 'Payment Gateways API'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Payment Gateways API</h2>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-sm font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-[<?php echo e($theme->theme_bg); ?>] hover:underline">Home</a> /
                    Payment Gateway / Create
                </p>
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-base font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    Dashboard
                </a>
            </div>
        </div>

        <!-- Form -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                <!-- Bkash -->
                <div class="border border-gray-300 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3" style="background-color: #E2136E;">
                        <span class="text-white text-xl font-semibold">Bkash</span>
                        <img src="https://www.logo.wine/a/logo/BKash/BKash-Icon-Logo.wine.svg" alt="Bkash Logo"
                            class="h-8 w-auto">
                    </div>

                    <form autocomplete="off" action="<?php echo e(route('admin.payment_gateways.store')); ?>" method="POST"
                        enctype="multipart/form-data" class="grid grid-cols-1 gap-3 px-4 py-4">
                        <?php echo csrf_field(); ?>

                        <!-- Hidden fake fields to prevent browser autofill -->
                        <input type="text" name="fakeusernameremembered" style="display:none">
                        <input type="password" name="fakepasswordremembered" style="display:none">

                        <input type="hidden" value="bkash" name="type">

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Number</label>
                            <input type="text" name="number" placeholder="Enter Number"
                                value="<?php echo e(old('number', $bkash->number ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">App Key</label>
                            <input type="text" name="app_key" placeholder="Enter App Key"
                                value="<?php echo e(old('app_key', $bkash->app_key ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">App Secret</label>
                            <input type="text" name="app_secret" placeholder="Enter App Secret"
                                value="<?php echo e(old('app_secret', $bkash->app_secret ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Base URL</label>
                            <input type="url" name="base_url" placeholder="Enter Base URL"
                                value="<?php echo e(old('base_url', $bkash->base_url ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Username</label>
                            <input type="text" name="username" placeholder="Enter Username"
                                value="<?php echo e(old('username', $bkash->username ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Password</label>
                            <input type="password" name="password" placeholder="Enter Password"
                                value="<?php echo e(old('password', $bkash->password ?? '')); ?>" autocomplete="new-password"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <label for="payment" class="block text-md text-gray-600 font-medium">Payment Type</label>
                        <select id="option" name="option"
                            class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2.5 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                            <option value="auto" <?php echo e(old('option', $bkash->option ?? '') == 'auto' ? 'selected' : ''); ?>>
                                Auto</option>
                            <option value="manual" <?php echo e(old('option', $bkash->option ?? '') == 'manual' ? 'selected' : ''); ?>>
                                Manually</option>
                        </select>

                        <div class="flex items-center justify-between">
                            <label class="text-gray-600 font-medium">Enable Bkash</label>
                            <input type="checkbox" name="status"
                                class="toggle-checkbox h-5 w-8 rounded-full bg-gray-300 checked:bg-[#FF6F00] transition duration-200"
                                <?php echo e(old('status', $bkash->status ?? 0) ? 'checked' : ''); ?>>
                        </div>

                        <div class="mt-3">
                            <button type="submit"
                                class="w-full rounded-md bg-[#E2136E] hover:bg-[#c40e5d] text-white py-2.5 font-medium transition-all">
                                Save
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Nagad -->
                <div class="border border-gray-300 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3" style="background-color: #F7941E;">
                        <span class="text-white text-xl font-semibold">Nagad</span>
                        <img src="https://www.bssnews.net/assets/news_photos/2022/02/04/image-42525-1643965434.jpg"
                            alt="Nagad Logo" class="h-8 w-auto">
                    </div>

                    <form autocomplete="off" action="<?php echo e(route('admin.payment_gateways.store')); ?>" method="POST"
                        enctype="multipart/form-data" class="grid grid-cols-1 gap-3 px-4 py-4">
                        <?php echo csrf_field(); ?>

                        <!-- Hidden fake fields to prevent browser autofill -->
                        <input type="text" name="fakeusernameremembered" style="display:none">
                        <input type="password" name="fakepasswordremembered" style="display:none">

                        <input type="hidden" value="nagad" name="type">

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Number</label>
                            <input type="text" name="number" placeholder="Enter Number"
                                value="<?php echo e(old('number', $nagad->number ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-pink-500 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">App Key</label>
                            <input type="text" name="app_key" placeholder="Enter App Key"
                                value="<?php echo e(old('app_key', $nagad->app_key ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">App Secret</label>
                            <input type="text" name="app_secret" placeholder="Enter App Secret"
                                value="<?php echo e(old('app_secret', $nagad->app_secret ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Base URL</label>
                            <input type="url" name="base_url" placeholder="Enter Base URL"
                                value="<?php echo e(old('base_url', $nagad->base_url ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Username</label>
                            <input type="text" name="username" placeholder="Enter Username"
                                value="<?php echo e(old('username', $nagad->username ?? '')); ?>" autocomplete="off"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                        </div>

                        <div>
                            <label class="block text-md text-gray-600 mb-1 font-medium">Password</label>
                            <input type="password" name="password" placeholder="Enter Password"
                                value="<?php echo e(old('password', $nagad->password ?? '')); ?>" autocomplete="new-password"
                                class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                        </div>

                        <label for="payment" class="block text-md text-gray-600 font-medium">Payment Type</label>
                        <select id="option" name="option"
                            class="w-full rounded-md text-gray-700 border border-gray-300 px-3 py-2.5 focus:ring-2 focus:ring-orange-400 outline-none transition-all">
                            <option value="auto" <?php echo e(old('option', $nagad->option ?? '') == 'auto' ? 'selected' : ''); ?>>
                                Auto</option>
                            <option value="manual"
                                <?php echo e(old('option', $nagad->option ?? '') == 'manual' ? 'selected' : ''); ?>>Manually</option>
                        </select>

                        <div class="flex items-center justify-between">
                            <label class="text-gray-600 font-medium">Enable Nagad</label>
                            <input type="checkbox" name="status"
                                class="toggle-checkbox h-5 w-8 rounded-full bg-gray-300 checked:bg-[#FF6F00] transition duration-200"
                                <?php echo e(old('status', $nagad->status ?? 0) ? 'checked' : ''); ?>>
                        </div>

                        <div class="mt-3">
                            <button type="submit"
                                class="w-full rounded-md bg-[#F7941E] hover:bg-[#dd7e10] text-white py-2.5 font-medium transition-all">
                                Save
                            </button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/payment/index.blade.php ENDPATH**/ ?>