<?php $__env->startSection('title', $product_subcategory->name); ?>
<?php $__env->startSection('content'); ?>
    <div class="bg-gray-50 py-4 px-4">
        <div class="max-w-6xl mx-auto grid grid-cols-12 gap-4">
            <form action="<?php echo e(route('subcategory.product', $product_subcategory->slug)); ?>" method="GET"
                class="col-span-12 md:col-span-3 hidden md:block bg-white h-fit rounded-lg shadow p-4 sticky top-4"
                id="categoryList">
                <h3 class="text-lg font-semibold mb-4">Filter Products</h3>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                    <ul class="space-y-2 text-sm">
                        <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="checkbox" name="categories[]" value="<?php echo e($category->id); ?>"
                                        class="form-checkbox"
                                        <?php echo e(in_array($category->id, request()->categories ?? []) ? 'checked' : ''); ?>>
                                    <span><?php echo e($category->name); ?></span>
                                </label>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                
                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Brands</h4>
                    <ul class="space-y-2 text-sm">
                        <?php $__currentLoopData = $allbrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="checkbox" name="brands[]" value="<?php echo e($brand->id); ?>" class="form-checkbox"
                                        <?php echo e(in_array($brand->id, request()->brands ?? []) ? 'checked' : ''); ?>>
                                    <span><?php echo e($brand->name); ?></span>
                                </label>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                    <div class="flex items-center gap-2">
                        <input type="number" name="min_price" placeholder="Min"
                            value="<?php echo e(request()->min_price ?? $minPrice); ?>"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                        <input type="number" name="max_price" placeholder="Max"
                            value="<?php echo e(request()->max_price ?? $maxPrice); ?>"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                    </div>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                    <div class="flex flex-col gap-1">
                        <?php for($i = 5; $i >= 1; $i--): ?>
                            <label class="flex items-center gap-2 cursor-pointer text-sm">
                                <input type="radio" name="rating" value="<?php echo e($i); ?>" class="form-radio"
                                    <?php echo e(request()->rating == $i ? 'checked' : ''); ?>>
                                <span class="flex gap-1">
                                    <?php for($j = 0; $j < $i; $j++): ?>
                                        <i class="ri-star-fill text-yellow-400"></i>
                                    <?php endfor; ?>
                                    <?php for($k = $i; $k < 5; $k++): ?>
                                        <i class="ri-star-line text-yellow-400"></i>
                                    <?php endfor; ?>
                                </span>
                            </label>
                        <?php endfor; ?>
                    </div>
                </div>

                <div class="flex gap-2 mt-4">
                    <button type="submit"
                        class="w-1/2 bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] py-2 rounded transition">Apply</button>
                    <a href="<?php echo e(route('subcategory.product', $product_subcategory->slug)); ?>"
                        class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                </div>
            </form>

            <!-- ================= Products Grid ================= -->
            <main class="col-span-12 md:col-span-9">

                <div class="md:hidden mb-3 -mt-1 flex justify-between items-center">
                    <form id="sortForm" action="<?php echo e(route('subcategory.product', $product_subcategory->slug)); ?>"
                        method="GET">
                        <?php $__currentLoopData = request()->categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="categories[]" value="<?php echo e($catId); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(request()->min_price): ?>
                            <input type="hidden" name="min_price" value="<?php echo e(request()->min_price); ?>">
                        <?php endif; ?>
                        <?php if(request()->max_price): ?>
                            <input type="hidden" name="max_price" value="<?php echo e(request()->max_price); ?>">
                        <?php endif; ?>
                        <?php if(request()->rating): ?>
                            <input type="hidden" name="rating" value="<?php echo e(request()->rating); ?>">
                        <?php endif; ?>
                        <select id="sortSelect" name="sort"
                            class="border border-gray-300 rounded-md px-3 py-[10px] text-sm focus:outline-none">
                            <option value="">Sort by</option>
                            <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to
                                High</option>
                            <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High
                                to Low</option>
                            <option value="rating" <?php echo e(request('sort') == 'rating' ? 'selected' : ''); ?>>Top Rated</option>
                        </select>
                    </form>

                    <button id="openFilter" type="button"
                        class="flex items-center gap-2 bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] px-4 py-[7px] rounded-md shadow hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                        <i class="ri-filter-3-line text-lg"></i> Filter
                    </button>
                </div>

                <div id="mobileFilterDrawer" class="fixed inset-0 z-50 bg-black/40 hidden justify-end md:hidden">
                    <div class="bg-white w-full h-full p-5 overflow-y-auto transform translate-x-full transition-transform duration-300"
                        id="filterPanel">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-800">Filter Products</h3>
                            <button id="closeFilter" type="button" class="text-gray-600 hover:text-gray-900 text-xl">
                                <i class="ri-close-line"></i>
                            </button>
                        </div>

                        <form action="<?php echo e(route('subcategory.product', $product_subcategory->slug)); ?>" method="GET"
                            class="space-y-6">
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                                <ul class="space-y-2 text-sm">
                                    <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <label class="flex items-center gap-2 cursor-pointer">
                                                <input type="checkbox" name="categories[]" value="<?php echo e($category->id); ?>"
                                                    class="form-checkbox"
                                                    <?php echo e(in_array($category->id, request()->categories ?? []) ? 'checked' : ''); ?>>
                                                <span><?php echo e($category->name); ?></span>
                                            </label>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Brands</h4>
                                <ul class="space-y-2 text-sm">
                                    <?php $__currentLoopData = $allbrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <label class="flex items-center gap-2 cursor-pointer">
                                                <input type="checkbox" name="brands[]" value="<?php echo e($brand->id); ?>"
                                                    class="form-checkbox"
                                                    <?php echo e(in_array($brand->id, request()->brands ?? []) ? 'checked' : ''); ?>>
                                                <span><?php echo e($brand->name); ?></span>
                                            </label>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                                <div class="flex items-center gap-2">
                                    <input type="number" name="min_price" placeholder="Min"
                                        value="<?php echo e(request()->min_price ?? $minPrice); ?>"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                                    <input type="number" name="max_price" placeholder="Max"
                                        value="<?php echo e(request()->max_price ?? $maxPrice); ?>"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>]">
                                </div>
                            </div>

                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                                <div class="flex flex-col gap-1">
                                    <?php for($i = 5; $i >= 1; $i--): ?>
                                        <label class="flex items-center gap-2 cursor-pointer text-sm">
                                            <input type="radio" name="rating" value="<?php echo e($i); ?>"
                                                class="form-radio" <?php echo e(request()->rating == $i ? 'checked' : ''); ?>>
                                            <span class="flex gap-1">
                                                <?php for($j = 0; $j < $i; $j++): ?>
                                                    <i class="ri-star-fill text-yellow-400"></i>
                                                <?php endfor; ?>
                                                <?php for($k = $i; $k < 5; $k++): ?>
                                                    <i class="ri-star-line text-yellow-400"></i>
                                                <?php endfor; ?>
                                            </span>
                                        </label>
                                    <?php endfor; ?>
                                </div>
                            </div>

                            <div class="flex gap-2 pt-2">
                                <button type="submit"
                                    class="w-1/2 bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] py-2 rounded transition">Apply</button>
                                <a href="<?php echo e(route('subcategory.product', $product_subcategory->slug)); ?>"
                                    class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-3 lg:grid-cols-4 gap-y-4 gap-x-2">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo $__env->make('frontend.products.index', ['product' => $product], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </main>
        </div>
    </div>
    <script>
        const openBtn = document.getElementById('openFilter');
        const closeBtn = document.getElementById('closeFilter');
        const drawer = document.getElementById('mobileFilterDrawer');
        const panel = document.getElementById('filterPanel');

        openBtn.addEventListener('click', () => {
            drawer.classList.remove('hidden');
            setTimeout(() => panel.classList.remove('translate-x-full'), 10);
        });

        closeBtn.addEventListener('click', () => {
            panel.classList.add('translate-x-full');
            setTimeout(() => drawer.classList.add('hidden'), 300);
        });

        drawer.addEventListener('click', (e) => {
            if (e.target === drawer) {
                panel.classList.add('translate-x-full');
                setTimeout(() => drawer.classList.add('hidden'), 300);
            }
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const sortSelect = document.getElementById("sortSelect");
            const sortForm = document.getElementById("sortForm");

            sortSelect.addEventListener("change", function() {
                if (this.value !== "") {
                    sortForm.submit();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/frontend/subcategory-product.blade.php ENDPATH**/ ?>