
<?php $__env->startSection('title', 'Customer Register'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

    <div class="grid grid-cols-1 items-center">

        <!-- Right Side : Register Form -->
        <div class="bg-white shadow rounded-lg p-6 md:p-8">

            <h1
                class="text-2xl font-medium mb-6 text-gray-800 relative inline-block after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[<?php echo e($theme->theme_bg); ?>] after:bottom-[-6px] after:left-0">
                📝 Customer Registration
            </h1>

            <?php if($errors->any()): ?>
                <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('customer.register.store')); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>

                <!-- Name -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Full Name</label>
                    <div class="relative">
                        <i class="ri-user-3-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="text" name="name" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Phone -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Phone Number</label>
                    <div class="relative">
                        <i class="ri-phone-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="text" name="phone" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Email -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Email Address</label>
                    <div class="relative">
                        <i class="ri-mail-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="email" name="email" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Password -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Password</label>
                    <div class="relative">
                        <i class="ri-lock-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="password" name="password" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Confirm Password -->
                <div>
                    <label class="block text-sm text-gray-600 mb-1">Confirm Password</label>
                    <div class="relative">
                        <i class="ri-lock-password-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                        <input type="password" name="password_confirmation" required
                            class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[<?php echo e($theme->theme_bg); ?>] focus:border-[<?php echo e($theme->theme_bg); ?>] outline-none transition">
                    </div>
                </div>

                <!-- Submit -->
                <button type="submit"
                    class="w-full bg-[<?php echo e($theme->theme_bg); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] text-[<?php echo e($theme->theme_text); ?>] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                    <i class="ri-user-add-line"></i>
                    Register
                </button>
            </form>

            <!-- Footer -->
            <div class="mt-6 text-center text-sm text-gray-600">
                Already have an account?
                <a href="<?php echo e(route('customer.login')); ?>"
                    class="text-[<?php echo e($theme->theme_bg); ?>] font-medium hover:underline">
                    Login here
                </a>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/customer/auth/register.blade.php ENDPATH**/ ?>