
<?php $__env->startSection('title', 'Add New Attribute Value'); ?>
<?php $__env->startSection('content'); ?>
    <div class="w-full flex flex-col gap-4 mb-20">
        <!-- Header -->
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Attribute Value</h2>
                <!-- Small Screen Button -->
                <a href="<?php echo e(route('admin.attribute_values.index')); ?>"
                    class="block md:hidden bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-sm font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Attribute Values
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-blue-600 hover:underline">Home</a> / Attribute Values
                    / Create
                </p>
                <!-- Large Screen Button -->
                <a href="<?php echo e(route('admin.attribute_values.index')); ?>"
                    class="hidden md:inline-flex items-center bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>]  px-4 py-2 rounded text-base font-medium hover:bg-[<?php echo e($theme->theme_hover); ?>] transition">
                    All Attribute Values
                </a>
            </div>
        </div>

        <!-- Form -->
        <div class="w-full bg-white rounded shadow px-6 py-6">
            <form action="<?php echo e(route('admin.attribute_values.store')); ?>" method="POST"
                class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 md:gap-6">
                <?php echo csrf_field(); ?>

                <!-- Attribute Selection -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 sm:mb-2 font-medium">Select Attribute</label>
                    <select name="attribute_id" required
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2
                        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="">-- Select Attribute --</option>
                        <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($attribute->id); ?>"
                                <?php echo e(old('attribute_id') == $attribute->id ? 'selected' : ''); ?>>
                                <?php echo e($attribute->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Attribute Value -->
                <div class="col-span-2">
                    <label class="block text-md text-gray-700 mb-1 sm:mb-2 font-medium">Value</label>
                    <input type="text" name="value" placeholder="Attribute Value" value="<?php echo e(old('value')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2
                        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                </div>

                <!-- Color Code -->
                <div class="col-span-2 md:col-span-2">
                    <label class="block text-md text-gray-700 mb-1 sm:mb-2 font-medium">Color Code (Optional)</label>
                    <input type="text" name="color_code" placeholder="#ffffff" value="<?php echo e(old('color_code')); ?>"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2
                        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                </div>

                <!-- Status -->
                <div class="col-span-2 md:col-span-2">
                    <label class="block text-md text-gray-700 mb-1 sm:mb-2 font-medium">Status</label>
                    <select name="status"
                        class="w-full rounded-md bg-white text-gray-900 border px-3 sm:px-4 py-2
                        text-sm sm:text-base outline-none focus:ring-2 focus:ring-[<?php echo e($theme->theme_bg); ?>] transition-all duration-200 border-gray-300">
                        <option value="1" <?php echo e(old('status') == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status') == 0 ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>

                <!-- Submit Button -->
                <div class="col-span-2 md:col-span-2 mt-2">
                    <button type="submit"
                        class="w-full rounded-md bg-[<?php echo e($theme->theme_bg); ?>] text-[<?php echo e($theme->theme_text); ?>] hover:bg-[<?php echo e($theme->theme_hover); ?>] disabled:opacity-60 disabled:cursor-not-allowed 
                        py-2.5 text-sm sm:text-base transition-all duration-200 transform">
                        Create Attribute Value
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mojibor1/public_html/resources/views/backend/attribute_values/create.blade.php ENDPATH**/ ?>