@extends('frontend.layouts.master')
@section('title', $product_subcategory->name)
@section('content')
    <div class="bg-gray-50 py-4 px-4">
        <div class="max-w-6xl mx-auto grid grid-cols-12 gap-4">
            <form action="{{ route('subcategory.product', $product_subcategory->slug) }}" method="GET"
                class="col-span-12 md:col-span-3 hidden md:block bg-white h-fit rounded-lg shadow p-4 sticky top-4"
                id="categoryList">
                <h3 class="text-lg font-semibold mb-4">Filter Products</h3>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                    <ul class="space-y-2 text-sm">
                        @foreach ($allcategories as $category)
                            <li>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="checkbox" name="categories[]" value="{{ $category->id }}"
                                        class="form-checkbox"
                                        {{ in_array($category->id, request()->categories ?? []) ? 'checked' : '' }}>
                                    <span>{{ $category->name }}</span>
                                </label>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Brands</h4>
                    <ul class="space-y-2 text-sm">
                        @foreach ($allbrands as $brand)
                            <li>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="checkbox" name="brands[]" value="{{ $brand->id }}" class="form-checkbox"
                                        {{ in_array($brand->id, request()->brands ?? []) ? 'checked' : '' }}>
                                    <span>{{ $brand->name }}</span>
                                </label>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                    <div class="flex items-center gap-2">
                        <input type="number" name="min_price" placeholder="Min"
                            value="{{ request()->min_price ?? $minPrice }}"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}]">
                        <input type="number" name="max_price" placeholder="Max"
                            value="{{ request()->max_price ?? $maxPrice }}"
                            class="w-1/2 border px-3 py-1.5 rounded focus:outline-none focus:ring-2 focus:ring-[{{ $theme->theme_bg }}]">
                    </div>
                </div>

                <div class="mb-6">
                    <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                    <div class="flex flex-col gap-1">
                        @for ($i = 5; $i >= 1; $i--)
                            <label class="flex items-center gap-2 cursor-pointer text-sm">
                                <input type="radio" name="rating" value="{{ $i }}" class="form-radio"
                                    {{ request()->rating == $i ? 'checked' : '' }}>
                                <span class="flex gap-1">
                                    @for ($j = 0; $j < $i; $j++)
                                        <i class="ri-star-fill text-yellow-400"></i>
                                    @endfor
                                    @for ($k = $i; $k < 5; $k++)
                                        <i class="ri-star-line text-yellow-400"></i>
                                    @endfor
                                </span>
                            </label>
                        @endfor
                    </div>
                </div>

                <div class="flex gap-2 mt-4">
                    <button type="submit"
                        class="w-1/2 bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] py-2 rounded transition">Apply</button>
                    <a href="{{ route('subcategory.product', $product_subcategory->slug) }}"
                        class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                </div>
            </form>

            <main class="col-span-12 md:col-span-9">

                <div class="md:hidden mb-3 -mt-1 flex justify-between items-center">
                    <form id="sortForm" action="{{ route('subcategory.product', $product_subcategory->slug) }}"
                        method="GET">
                        @foreach (request()->categories ?? [] as $catId)
                            <input type="hidden" name="categories[]" value="{{ $catId }}">
                        @endforeach
                        @if (request()->min_price)
                            <input type="hidden" name="min_price" value="{{ request()->min_price }}">
                        @endif
                        @if (request()->max_price)
                            <input type="hidden" name="max_price" value="{{ request()->max_price }}">
                        @endif
                        @if (request()->rating)
                            <input type="hidden" name="rating" value="{{ request()->rating }}">
                        @endif
                        <select id="sortSelect" name="sort"
                            class="border border-gray-300 rounded-md px-3 py-[10px] text-sm focus:outline-none">
                            <option value="">Sort by</option>
                            <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price: Low to
                                High</option>
                            <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price: High
                                to Low</option>
                            <option value="rating" {{ request('sort') == 'rating' ? 'selected' : '' }}>Top Rated</option>
                        </select>
                    </form>

                    <button id="openFilter" type="button"
                        class="flex items-center gap-2 bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] px-4 py-[7px] rounded-md shadow hover:bg-[{{ $theme->theme_hover }}] transition">
                        <i class="ri-filter-3-line text-lg"></i> Filter
                    </button>
                </div>

                <div id="mobileFilterDrawer" class="fixed inset-0 z-50 bg-black/40 hidden justify-end md:hidden">
                    <div class="bg-white w-full h-full p-5 overflow-y-auto transform translate-x-full transition-transform duration-300"
                        id="filterPanel">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-800">Filter Products</h3>
                            <button id="closeFilter" type="button" class="text-gray-600 hover:text-gray-900 text-xl">
                                <i class="ri-close-line"></i>
                            </button>
                        </div>

                        <form action="{{ route('subcategory.product', $product_subcategory->slug) }}" method="GET"
                            class="space-y-6">
                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Categories</h4>
                                <ul class="space-y-2 text-sm">
                                    @foreach ($allcategories as $category)
                                        <li>
                                            <label class="flex items-center gap-2 cursor-pointer">
                                                <input type="checkbox" name="categories[]" value="{{ $category->id }}"
                                                    class="form-checkbox"
                                                    {{ in_array($category->id, request()->categories ?? []) ? 'checked' : '' }}>
                                                <span>{{ $category->name }}</span>
                                            </label>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Brands</h4>
                                <ul class="space-y-2 text-sm">
                                    @foreach ($allbrands as $brand)
                                        <li>
                                            <label class="flex items-center gap-2 cursor-pointer">
                                                <input type="checkbox" name="brands[]" value="{{ $brand->id }}"
                                                    class="form-checkbox"
                                                    {{ in_array($brand->id, request()->brands ?? []) ? 'checked' : '' }}>
                                                <span>{{ $brand->name }}</span>
                                            </label>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Price</h4>
                                <div class="flex items-center gap-2">
                                    <input type="number" name="min_price" placeholder="Min"
                                        value="{{ request()->min_price ?? $minPrice }}"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[{{ $theme->theme_bg }}]">
                                    <input type="number" name="max_price" placeholder="Max"
                                        value="{{ request()->max_price ?? $maxPrice }}"
                                        class="w-1/2 border px-3 py-1.5 rounded focus:ring-2 focus:ring-[{{ $theme->theme_bg }}]">
                                </div>
                            </div>

                            <div>
                                <h4 class="font-medium mb-2 text-gray-700">Rating</h4>
                                <div class="flex flex-col gap-1">
                                    @for ($i = 5; $i >= 1; $i--)
                                        <label class="flex items-center gap-2 cursor-pointer text-sm">
                                            <input type="radio" name="rating" value="{{ $i }}"
                                                class="form-radio" {{ request()->rating == $i ? 'checked' : '' }}>
                                            <span class="flex gap-1">
                                                @for ($j = 0; $j < $i; $j++)
                                                    <i class="ri-star-fill text-yellow-400"></i>
                                                @endfor
                                                @for ($k = $i; $k < 5; $k++)
                                                    <i class="ri-star-line text-yellow-400"></i>
                                                @endfor
                                            </span>
                                        </label>
                                    @endfor
                                </div>
                            </div>

                            <div class="flex gap-2 pt-2">
                                <button type="submit"
                                    class="w-1/2 bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] py-2 rounded transition">Apply</button>
                                <a href="{{ route('subcategory.product', $product_subcategory->slug) }}"
                                    class="w-1/2 bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 rounded transition text-center">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-3 lg:grid-cols-4 gap-y-4 gap-x-2">
                    @foreach ($products as $product)
                        @include('frontend.products.index', ['product' => $product])
                    @endforeach
                </div>
            </main>
        </div>
    </div>
    <script>
        const openBtn = document.getElementById('openFilter');
        const closeBtn = document.getElementById('closeFilter');
        const drawer = document.getElementById('mobileFilterDrawer');
        const panel = document.getElementById('filterPanel');

        openBtn.addEventListener('click', () => {
            drawer.classList.remove('hidden');
            setTimeout(() => panel.classList.remove('translate-x-full'), 10);
        });

        closeBtn.addEventListener('click', () => {
            panel.classList.add('translate-x-full');
            setTimeout(() => drawer.classList.add('hidden'), 300);
        });

        drawer.addEventListener('click', (e) => {
            if (e.target === drawer) {
                panel.classList.add('translate-x-full');
                setTimeout(() => drawer.classList.add('hidden'), 300);
            }
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const sortSelect = document.getElementById("sortSelect");
            const sortForm = document.getElementById("sortForm");

            sortSelect.addEventListener("change", function() {
                if (this.value !== "") {
                    sortForm.submit();
                }
            });
        });
    </script>
@endsection
