@extends('frontend.layouts.master')
@section('title', 'Checkout')
@section('content')
    <div class="max-w-6xl mx-auto my-4 px-4 md:px-6 lg:px-0">
        <h1
            class="text-2xl font-semibold mb-6 text-gray-800 relative inline-block
        after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[{{ $theme->theme_bg }}] after:bottom-[-6px] after:left-0">
            🛍️ Checkout
        </h1>

        @php
            $cart = session('cart', []);
            $buyNow = session('buy_now', null);
        @endphp

        @if ($buyNow)
            @php $subtotal = $buyNow['price'] * $buyNow['quantity']; @endphp
            <form action="{{ route('payment') }}" method="POST" class="flex flex-col lg:flex-row gap-4">
                @csrf
                <input type="hidden" name="product[id]" value="{{ $buyNow['id'] }}">
                <input type="hidden" name="incomplete" value="" id="incomplete-flag">
                <input type="hidden" name="product[name]" value="{{ $buyNow['name'] }}">
                <input type="hidden" name="product[price]" value="{{ $buyNow['price'] }}">
                <input type="hidden" name="product[quantity]" value="{{ $buyNow['quantity'] }}">
                <input type="hidden" name="product[variant_id]" value="{{ $buyNow['variant_id'] }}">
                <input type="hidden" name="product[image]" value="{{ $buyNow['image'] }}">
                @if (!empty($buyNow['variants']) && is_array($buyNow['variants']))
                    <input type="hidden" name="product[attributes]" value='@json($buyNow['variants'])'>
                @else
                    <input type="hidden" name="product[attributes]" value="{}">
                @endif
                <div class="lg:w-2/3 bg-white shadow rounded-lg md:p-6 p-4">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                        <i class="ri-user-line text-[{{ $theme->theme_bg }}]"></i>কাস্টমার তথ্য
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label class="text-md mb-1 text-gray-600">আপনার নাম</label>
                            <input type="text" name="name" value="{{ old('name') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="আপনার নাম লিখুন">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">ইমেইল ঠিকানা</label>
                            <input type="email" name="email" value="{{ old('email') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="you@example.com">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">ফোন নাম্বার</label>
                            <input type="tel" name="phone" value="{{ old('phone') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="+8801XXXXXXXXX">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">শহরের নাম</label>
                            <input type="text" name="city" value="{{ old('city') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="শহরের নাম লিখুন">
                        </div>

                        <div class="md:col-span-2">
                            <label class="text-md mb-1 text-gray-600">ডেলিভারি এরিয়া</label>
                            <select name="charge" id="deliveryArea" required
                                class="deliveryArea w-full border border-gray-300 rounded px-3 py-[10px] text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none">
                                <option value="{{ $inDhakaCharge }}">ঢাকার ভিতরে</option>
                                <option value="{{ $outDhakaCharge }}">ঢাকার বাইরে</option>
                            </select>
                        </div>

                        <div class="md:col-span-2">
                            <label class="text-md mb-1 text-gray-600">সম্পূর্ণ ঠিকানা</label>
                            <textarea name="address" rows="3" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="বাড়ি, রোড, এরিয়া">{{ old('address') }}</textarea>
                        </div>
                    </div>

                    <h2 class="text-lg font-semibold flex items-center gap-2">
                        <i class="ri-shopping-bag-3-line text-[{{ $theme->theme_bg }}]"></i>অর্ডার বিবরণ
                    </h2>
                    <div class="flex flex-col gap-2">
                        <div class="flex items-center justify-between border-b border-gray-200 py-4 cart-item"
                            data-id="{{ $buyNow['id'] }}">
                            <div class="flex items-center md:gap-4 gap-3">
                                <img loading="lazy" src="{{ $buyNow['image'] }}" alt="{{ $buyNow['name'] }}"
                                    class="w-[68px] md:h-[68px] h-[86px] object-cover rounded">
                                <div>
                                    <h3 class="font-medium text-gray-800 line-clamp-1">
                                        {{ \Illuminate\Support\Str::limit($buyNow['name'], 30) }}</h3>
                                    <div class="flex md:flex-row flex-col md:items-center items-start md:gap-2">
                                        <p class="text-gray-500 text-sm">Variation:</p>
                                        <div class="flex items-center gap-2 flex-wrap">
                                            @if (!empty($buyNow['variants']) && is_array($buyNow['variants']))
                                                @foreach ($buyNow['variants'] as $key => $value)
                                                    <div class="bg-white border rounded text-xs text-gray-700 px-3 py-1">
                                                        <span class="hidden md:inline">{{ ucfirst($key) }}: </span>
                                                        {{ $value }}
                                                    </div>
                                                @endforeach
                                            @else
                                                <div class="bg-white border rounded text-xs text-gray-700 px-3 py-1">Default
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <p class="text-gray-500 text-sm mt-1">Qty: {{ $buyNow['quantity'] }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-gray-800 font-semibold">
                                    ৳{{ number_format($buyNow['price'] * $buyNow['quantity'], 0) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="lg:w-1/3 bg-white shadow rounded-lg p-6 h-fit">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2"><i
                            class="ri-bill-line text-[{{ $theme->theme_bg }}]"></i>Order Summary</h2>

                    <div class="flex justify-between mb-2">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="font-medium text-gray-800 subtotal">৳{{ number_format($subtotal, 0) }}</span>
                    </div>
                    <div class="flex justify-between mb-2">
                        <span class="text-gray-600">Shipping Charge</span>
                        <span class="font-medium text-gray-800 shipping">৳ 0.00</span>
                    </div>
                    <div class="border-t border-gray-200 mt-2 mb-4"></div>
                    <div class="flex justify-between text-lg font-semibold mb-6">
                        <span>Total</span>
                        <span class="total">৳{{ number_format($subtotal) }}</span>
                    </div>

                    <h3 class="text-md font-semibold mb-3 flex items-center gap-2"><i
                            class="ri-bank-card-line text-[{{ $theme->theme_bg }}]"></i>Payment Method</h3>
                    <div class="space-y-3 mb-6">
                        <h2 class="font-semibold text-gray-800 mb-2">Select Payment Method</h2>
                        <div class="grid grid-cols-3 gap-2">
                            <div class="payment-card border border-gray-300 rounded-lg px-2 cursor-pointer text-center transition-all duration-300 hover:scale-95"
                                data-method="cod" onclick="selectPayment('cod')">

                                <img src="https://i.postimg.cc/9MHJ56gV/Cash.webp" alt="Cash on Delivery"
                                    class="w-24 h-12 mx-auto">
                            </div>

                            @if ($bkashStatus == 1)
                                <div class="payment-card border border-gray-300 rounded-lg px-2 text-center transition-all duration-300 
                                cursor-pointer hover:scale-95"
                                    data-method="bkash" onclick="selectPayment('bkash')">

                                    <img src="https://www.logo.wine/a/logo/BKash/BKash-bKash-Logo.wine.svg" alt="bKash"
                                        class="w-24 h-12 mx-auto">
                                </div>
                            @endif

                            @if ($nagadStatus == 1)
                                <div class="payment-card border border-gray-300 rounded-lg px-2 text-center transition-all duration-300 
                                cursor-pointer hover:scale-95"
                                    data-method="nagad" onclick="selectPayment('nagad')">

                                    <img src="https://www.logo.wine/a/logo/Nagad/Nagad-Logo.wine.svg" alt="Nagad"
                                        class="w-24 h-12 mx-auto">
                                </div>
                            @endif

                        </div>
                        <input type="hidden" name="payment_method" id="selectedPaymentMethod" value="cod">
                    </div>

                    <style>
                        .payment-card {
                            transition: all 0.3s ease;
                        }

                        .payment-card.active {
                            border: 2px solid;
                            border-color: #f97316;
                            background-color: #fff7ed;
                        }
                    </style>

                    <script>
                        const paymentCards = document.querySelectorAll('.payment-card');
                        const hiddenInput = document.getElementById('selectedPaymentMethod');

                        paymentCards.forEach(card => {
                            card.addEventListener('click', () => {
                                paymentCards.forEach(c => c.classList.remove('active'));

                                card.classList.add('active');

                                hiddenInput.value = card.getAttribute('data-method');
                            });
                        });

                        document.addEventListener('DOMContentLoaded', () => {
                            const defaultCard = document.querySelector('[data-method="cod"]');
                            if (defaultCard) defaultCard.classList.add('active');
                        });
                    </script>

                    <button type="submit"
                        class="w-full bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] font-semibold py-3 rounded-lg transition">
                        <i class="ri-lock-line mr-1"></i> Confirm & Place Order
                    </button>
                </div>
            </form>
        @elseif(count($cart) > 0)
            @php $subtotal = 0; @endphp
            <form action="{{ route('payment') }}" method="POST" class="flex flex-col lg:flex-row gap-4">
                @csrf
                @foreach ($cart as $id => $item)
                    <input type="hidden" name="incomplete" value="" class="incomplete-flag">
                    <input type="hidden" name="products[{{ $id }}][id]" value="{{ $id }}">
                    <input type="hidden" name="products[{{ $id }}][name]" value="{{ $item['name'] }}">
                    <input type="hidden" name="products[{{ $id }}][price]" value="{{ $item['price'] }}">
                    <input type="hidden" name="products[{{ $id }}][quantity]"
                        value="{{ $item['quantity'] }}">
                    <input type="hidden" name="products[{{ $id }}][variant_id]"
                        value="{{ $item['variant_id'] }}">
                    <input type="hidden" name="products[{{ $id }}][image]" value="{{ $item['image'] }}">
                    @if (!empty($item['variants']) && is_array($item['variants']))
                        <input type="hidden" name="products[{{ $id }}][attributes]"
                            value='@json($item['variants'])'>
                    @else
                        <input type="hidden" name="products[{{ $id }}][attributes]" value="{}">
                    @endif
                @endforeach
                <div class="lg:w-2/3 bg-white shadow rounded-lg md:p-6 p-4">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                        <i class="ri-user-line text-[{{ $theme->theme_bg }}]"></i>কাস্টমার তথ্য
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">

                        <div>
                            <label class="text-md mb-1 text-gray-600">আপনার নাম</label>
                            <input type="text" name="name" value="{{ old('name') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="আপনার নাম লিখুন">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">ইমেইল ঠিকানা</label>
                            <input type="email" name="email" value="{{ old('email') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="আপনার ইমেইল লিখুন">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">ফোন নম্বর</label>
                            <input type="tel" name="phone" value="{{ old('phone') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="+8801XXXXXXXXX">
                        </div>

                        <div>
                            <label class="text-md mb-1 text-gray-600">শহর</label>
                            <input type="text" name="city" value="{{ old('city') }}" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="শহরের নাম লিখুন">
                        </div>

                        <div class="md:col-span-2">
                            <label class="text-md mb-1 text-gray-600">ডেলিভারি এরিয়া</label>
                            <select name="charge" id="deliveryArea" required
                                class="deliveryArea w-full border border-gray-300 rounded px-3 py-[10px] text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none">
                                <option value="{{ $inDhakaCharge }}">ঢাকার ভিতরে</option>
                                <option value="{{ $outDhakaCharge }}">ঢাকার বাইরে</option>
                            </select>
                        </div>

                        <div class="md:col-span-2">
                            <label class="text-md mb-1 text-gray-600">সম্পূর্ণ ঠিকানা</label>
                            <textarea name="address" rows="3" required
                                class="w-full border border-gray-300 rounded px-3 py-2 text-md focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] outline-none"
                                placeholder="বাড়ি, রোড, এরিয়া লিখুন">{{ old('address') }}</textarea>
                        </div>

                    </div>

                    <h2 class="text-lg font-semibold flex items-center gap-2">
                        <i class="ri-shopping-bag-3-line text-[{{ $theme->theme_bg }}]"></i>অর্ডার বিবরণ
                    </h2>
                    <div class="flex flex-col gap-2">
                        @foreach ($cart as $id => $item)
                            @php $subtotal += $item['price'] * $item['quantity']; @endphp
                            <div class="flex items-center justify-between border-b border-gray-200 py-4 cart-item"
                                data-id="{{ $id }}">
                                <div class="flex items-center md:gap-4 gap-3">
                                    <img loading="lazy" src="{{ $item['image'] }}" alt="{{ $item['name'] }}"
                                        class="w-[68px] md:h-[68px] h-[86px] object-cover rounded">
                                    <div>
                                        <h3 class="font-medium text-gray-800 line-clamp-1">
                                            {{ \Illuminate\Support\Str::limit($item['name'], 30) }}</h3>
                                        <div class="flex md:flex-row flex-col md:items-center items-start md:gap-2">
                                            <p class="text-gray-500 text-sm">Variation:</p>
                                            <div class="flex items-center gap-2 flex-wrap">
                                                @if (!empty($item['variants']) && is_array($item['variants']))
                                                    @foreach ($item['variants'] as $key => $value)
                                                        <div
                                                            class="bg-white border rounded text-xs text-gray-700 px-3 py-1">
                                                            <span class="hidden md:inline">{{ ucfirst($key) }}: </span>
                                                            {{ $value }}
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="bg-white border rounded text-xs text-gray-700 px-3 py-1">
                                                        Default</div>
                                                @endif
                                            </div>
                                        </div>
                                        <p class="text-gray-500 text-sm mt-1">Qty:
                                            <input type="number" value="{{ $item['quantity'] }}" min="1"
                                                class="w-14 border border-gray-300 rounded px-2 py-0.5 text-sm focus:border-[{{ $theme->theme_bg }}] focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] transition duration-200 outline-none quantity-input"
                                                data-id="{{ $id }}">
                                        </p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-gray-800 font-semibold">
                                        ৳{{ number_format($item['price'] * $item['quantity'], 0) }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="lg:w-1/3 bg-white shadow rounded-lg md:p-6 p-4 h-fit">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2"><i
                            class="ri-bill-line text-[{{ $theme->theme_bg }}]"></i>Order Summary</h2>

                    <div class="flex justify-between mb-2">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="font-medium text-gray-800 subtotal">৳{{ number_format($subtotal, 0) }}</span>
                    </div>
                    <div class="flex justify-between mb-2">
                        <span class="text-gray-600">Shipping Charge</span>
                        <span class="font-medium text-gray-800 shipping">৳ 0.00</span>
                    </div>
                    <div class="border-t border-gray-200 mt-2 mb-4"></div>
                    <div class="flex justify-between text-lg font-semibold mb-6">
                        <span>Total</span>
                        <span class="total">৳{{ number_format($subtotal) }}</span>
                    </div>

                    <h3 class="text-md font-semibold mb-3 flex items-center gap-2"><i
                            class="ri-bank-card-line text-[{{ $theme->theme_bg }}]"></i>Payment Method</h3>

                    <div class="space-y-3 mb-6">
                        <h2 class="font-semibold text-gray-800 mb-2">Select Payment Method</h2>
                        <div class="grid grid-cols-3 gap-2">
                            <div class="payment-card border border-gray-300 rounded-lg px-2 cursor-pointer text-center transition-all duration-300 hover:scale-95"
                                data-method="cod" onclick="selectPayment('cod')">

                                <img src="https://i.postimg.cc/9MHJ56gV/Cash.webp" alt="Cash on Delivery"
                                    class="w-24 h-12 mx-auto">
                            </div>

                            @if ($bkashStatus == 1)
                                <div class="payment-card border border-gray-300 rounded-lg px-2 text-center transition-all duration-300 
                            cursor-pointer hover:scale-95"
                                    data-method="bkash" onclick="selectPayment('bkash')">

                                    <img src="https://www.logo.wine/a/logo/BKash/BKash-bKash-Logo.wine.svg" alt="bKash"
                                        class="w-24 h-12 mx-auto">
                                </div>
                            @endif

                            @if ($nagadStatus == 1)
                                <div class="payment-card border border-gray-300 rounded-lg px-2 text-center transition-all duration-300 
                                cursor-pointer hover:scale-95"
                                    data-method="nagad" onclick="selectPayment('nagad')">

                                    <img src="https://www.logo.wine/a/logo/Nagad/Nagad-Logo.wine.svg" alt="Nagad"
                                        class="w-24 h-12 mx-auto">
                                </div>
                            @endif


                        </div>
                        <input type="hidden" name="payment_method" id="selectedPaymentMethod" value="cod">
                    </div>

                    <style>
                        .payment-card {
                            transition: all 0.3s ease;
                        }

                        .payment-card.active {
                            border: 2px solid;
                            border-color: #712f00;
                            background-color: #fff7ed;
                        }
                    </style>

                    <script>
                        const paymentCards = document.querySelectorAll('.payment-card');
                        const hiddenInput = document.getElementById('selectedPaymentMethod');

                        paymentCards.forEach(card => {
                            card.addEventListener('click', () => {
                                paymentCards.forEach(c => c.classList.remove('active'));

                                card.classList.add('active');

                                hiddenInput.value = card.getAttribute('data-method');
                            });
                        });

                        document.addEventListener('DOMContentLoaded', () => {
                            const defaultCard = document.querySelector('[data-method="cod"]');
                            if (defaultCard) defaultCard.classList.add('active');
                        });
                    </script>
                    <button type="submit"
                        class="w-full bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] font-semibold py-3 rounded-lg transition">
                        <i class="ri-lock-line mr-1"></i> Confirm & Place Order
                    </button>
                </div>
            </form>
        @else
            <div class="flex flex-col items-center justify-center py-16 bg-gray-50 rounded-lg shadow">
                <img loading="lazy" src="https://cdn-icons-png.flaticon.com/512/2038/2038854.png" alt="Empty Cart"
                    class="w-40 h-40 mb-6 animate-bounce">
                <h2 class="text-2xl font-semibold text-gray-700 mb-2">Your Cart is Empty</h2>
                <p class="text-gray-500 mb-6 text-center px-4">Looks like you haven't added any products yet. Start
                    shopping
                    and fill your cart!</p>
                <a href="{{ route('home') }}"
                    class="bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] font-semibold py-3 px-6 rounded-lg transition">
                    Continue Shopping
                </a>
            </div>
        @endif
    </div>

    <!-- GTM + Pixel: InitiateCheckout -->

    @if ($buyNow)
        <script>
            (function() {
                var value = {{ $buyNow['price'] * $buyNow['quantity'] }};
                var ids = @json([$buyNow['id']]);

                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'InitiateCheckout',
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product'
                    });
                }

                if (typeof fbq === 'function') {
                    fbq('track', 'InitiateCheckout', {
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product'
                    });
                }
            })();
        </script>
    @elseif(count($cart) > 0)
        <script>
            (function() {
                var value = {{ collect($cart)->sum(fn($item) => $item['price'] * $item['quantity']) }};
                var ids = @json(array_column($cart, 'id'));

                if (window.dataLayer) {
                    dataLayer.push({
                        event: 'InitiateCheckout',
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product'
                    });
                }

                if (typeof fbq === 'function') {
                    fbq('track', 'InitiateCheckout', {
                        value: value,
                        currency: 'BDT',
                        content_ids: ids,
                        content_type: 'product'
                    });
                }

            })();
        </script>
    @endif

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const formFields = document.querySelectorAll(
                "input[name='name'], input[name='email'], input[name='phone'], input[name='city'], textarea[name='address'], select[name='charge']"
            );

            let ajaxTimeout;

            function getProductData() {
                const buyNowInputs = document.querySelectorAll("input[name^='product']");
                const cartInputs = document.querySelectorAll("input[name^='products']");

                let products = [];

                if (buyNowInputs.length > 0) {
                    let product = {};
                    buyNowInputs.forEach(input => {
                        const match = input.name.match(/product\[(.+)\]/);
                        if (match) product[match[1]] = input.value;
                    });
                    products.push(product);
                }

                if (cartInputs.length > 0) {
                    const productMap = {};

                    cartInputs.forEach(input => {
                        const match = input.name.match(/products\[(\d+)\]\[(.+)\]/);
                        if (match) {
                            const id = match[1];
                            const field = match[2];
                            if (!productMap[id]) productMap[id] = {};
                            productMap[id][field] = input.value;
                        }
                    });

                    const cartProducts = Object.values(productMap);
                    products = products.concat(cartProducts);
                }

                return products;
            }

            function sendAjax() {
                const data = {
                    _token: '{{ csrf_token() }}',
                    name: document.querySelector("input[name='name']").value.trim(),
                    email: document.querySelector("input[name='email']").value.trim(),
                    phone: document.querySelector("input[name='phone']").value.trim(),
                    city: document.querySelector("input[name='city']").value.trim(),
                    address: document.querySelector("textarea[name='address']").value.trim(),
                    charge: document.querySelector("select[name='charge']").value,
                    products: getProductData()
                };

                fetch('/order/incomplete', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': data._token
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.status === 'success' && result.order_id) {
                            const buyNowInput = document.getElementById('incomplete-flag');
                            if (buyNowInput) buyNowInput.value = result.order_id;

                            const cartInputs = document.querySelectorAll('.incomplete-flag');
                            cartInputs.forEach(input => input.value = result.order_id);
                        }
                    })
                    .catch(error => {
                        console.error('AJAX Error:', error);
                    });
            }

            function checkFields() {
                let allFilled = true;

                formFields.forEach(field => {
                    if (!field.value.trim()) {
                        allFilled = false;
                    }
                });

                if (allFilled) {
                    if (ajaxTimeout) clearTimeout(ajaxTimeout);
                    ajaxTimeout = setTimeout(sendAjax, 2000);
                } else {
                    if (ajaxTimeout) clearTimeout(ajaxTimeout);
                }
            }

            formFields.forEach(field => {
                field.addEventListener("input", checkFields);
                field.addEventListener("change", checkFields);
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.quantity-input').on('change', function() {
                var id = $(this).data('id');
                var quantity = $(this).val();

                $.ajax({
                    url: '/cart/update/' + id,
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        quantity: quantity
                    },
                    success: function(response) {
                        if (response.success) {
                            $('input[data-id="' + id + '"]').closest(
                                '.flex.items-center.justify-between').find(
                                'p.text-gray-800').text('৳' + response.item_total
                                .toLocaleString());

                            $('.lg\\:w-1\\/3 span.subtotal').text('৳' + response.subtotal
                                .toLocaleString());
                            $('.lg\\:w-1\\/3 span.total').text('৳' + response.total
                                .toLocaleString());
                        }
                    }
                });
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            function updateTotal(dropdown) {
                const formContainer = $(dropdown).closest('form');
                let subtotalText = formContainer.find('.subtotal').first().text().replace(/[৳,]/g, '');
                let subtotal = parseFloat(subtotalText) || 0;
                let charge = parseFloat($(dropdown).val()) || 0;
                formContainer.find('.shipping').text('৳' + charge.toLocaleString());
                let total = subtotal + charge;
                formContainer.find('.total').text('৳' + total.toLocaleString());
            }

            $('.deliveryArea').on('change', function() {
                updateTotal(this);
            });

            $('.deliveryArea').each(function() {
                updateTotal(this);
            });
        });
    </script>
@endsection
