@extends('frontend.layouts.master')
@section('title', 'Reset Password')

@section('content')
    <div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-center">

            <div class="hidden lg:flex flex-col justify-center bg-white shadow rounded-lg p-8 h-[-webkit-fill-available]">
                <h2 class="text-3xl font-semibold text-gray-800 mb-4">Reset Password 🔐</h2>
                <p class="text-gray-600 mb-6">
                    Enter your new password and confirm it to complete the reset process.
                </p>
            </div>

            <div class="bg-white shadow rounded-lg p-6 md:p-8">

                <h1
                    class="text-2xl font-medium mb-6 text-gray-800 relative inline-block 
                       after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[{{ $theme->theme_bg }}] after:bottom-[-6px] after:left-0">
                    🔑 Reset Password
                </h1>

                @if ($errors->any())
                    <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                        {{ $errors->first() }}
                    </div>
                @endif

                <form method="POST" action="{{ route('customer.reset-password.post') }}" class="space-y-4">
                    @csrf
                    <input type="hidden" name="email" value="{{ session('email') }}">

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">New Password</label>
                        <div class="relative">
                            <i class="ri-lock-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                            <input type="password" name="password" required
                                class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] focus:border-[{{ $theme->theme_bg }}] outline-none transition"
                                placeholder="Enter new password">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Confirm Password</label>
                        <div class="relative">
                            <i class="ri-lock-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                            <input type="password" name="password_confirmation" required
                                class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] focus:border-[{{ $theme->theme_bg }}] outline-none transition"
                                placeholder="Confirm new password">
                        </div>
                    </div>

                    <button type="submit"
                        class="w-full bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                        <i class="ri-refresh-line"></i>
                        Reset Password
                    </button>
                </form>

            </div>
        </div>
    </div>
@endsection
