@extends('frontend.layouts.master')
@section('title', 'Forget Password')

@section('content')
    <div class="max-w-6xl mx-auto my-8 px-4 md:px-6 lg:px-0">

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-center">

            <div class="hidden lg:flex flex-col justify-center bg-white shadow rounded-lg p-8 h-[-webkit-fill-available]">
                <h2 class="text-3xl font-semibold text-gray-800 mb-4">Forgot Your Password? 🔑</h2>
                <p class="text-gray-600 mb-6">
                    Enter your registered email and we'll send you a OTP to reset your password.
                </p>

                <ul class="space-y-3 text-gray-600">
                    <li class="flex items-center gap-2">
                        <i class="ri-check-line text-[{{ $theme->theme_bg }}] text-lg"></i>
                        Fast OTP Delivery
                    </li>
                    <li class="flex items-center gap-2">
                        <i class="ri-check-line text-[{{ $theme->theme_bg }}] text-lg"></i>
                        Secure Account
                    </li>
                    <li class="flex items-center gap-2">
                        <i class="ri-check-line text-[{{ $theme->theme_bg }}] text-lg"></i>
                        Easy Reset
                    </li>
                </ul>
            </div>

            <div class="bg-white shadow rounded-lg p-6 md:p-8">

                <h1
                    class="text-2xl font-medium mb-6 text-gray-800 relative inline-block 
                       after:content-[''] after:absolute after:w-1/2 after:h-[3px] after:bg-[{{ $theme->theme_bg }}] after:bottom-[-6px] after:left-0">
                    🔐 Forget Password
                </h1>

                @if (session('error'))
                    <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded p-3">
                        {{ session('error') }}
                    </div>
                @endif

                @if (session('success'))
                    <div class="mb-4 text-sm text-green-600 bg-green-50 border border-green-200 rounded p-3">
                        {{ session('success') }}
                    </div>
                @endif

                <form method="POST" action="{{ route('customer.send-otp') }}" class="space-y-4">
                    @csrf

                    <div>
                        <label class="block text-sm text-gray-600 mb-1">Email Address</label>
                        <div class="relative">
                            <i class="ri-mail-line absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i>
                            <input type="email" name="email" required
                                class="w-full pl-10 pr-4 py-2.5 border rounded-lg focus:ring-1 focus:ring-[{{ $theme->theme_bg }}] focus:border-[{{ $theme->theme_bg }}] outline-none transition"
                                placeholder="Enter your email">
                        </div>
                    </div>

                    <button type="submit"
                        class="w-full bg-[{{ $theme->theme_bg }}] hover:bg-[{{ $theme->theme_hover }}] text-[{{ $theme->theme_text }}] font-medium py-3 rounded-lg transition flex items-center justify-center gap-2">
                        <i class="ri-mail-send-line"></i>
                        Send OTP
                    </button>
                </form>

                <div class="mt-6 text-center text-sm text-gray-600">
                    Remember password?
                    <button id="loginBtn" class="loginBtn text-[{{ $theme->theme_bg }}] font-medium hover:underline">
                        Login
                    </button>
                </div>

            </div>
        </div>
    </div>
@endsection
