@extends('backend.layouts.app')
@section('title', 'Courier Gateway API')
@section('content')
    <div class="w-full flex flex-col gap-4 mb-20">
        <div class="flex flex-col bg-white shadow rounded md:p-6 p-4 md:gap-1 gap-3">
            <div class="flex justify-between items-center">
                <h2 class="text-2xl font-bold text-gray-800 mb-2">Courier Gateway API</h2>
                <a href="{{ route('admin.dashboard') }}"
                    class="block md:hidden bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] px-4 py-2 rounded text-sm font-medium hover:bg-[{{ $theme->theme_hover }}] transition">
                    Dashboard
                </a>
            </div>
            <div class="flex justify-between items-center text-gray-600 text-sm">
                <p>
                    <a href="{{ route('admin.dashboard') }}" class="text-[{{ $theme->theme_bg }}] hover:underline">Home</a> /
                    Courier / API Settings
                </p>
                <a href="{{ route('admin.dashboard') }}"
                    class="hidden md:inline-flex items-center bg-[{{ $theme->theme_bg }}] text-[{{ $theme->theme_text }}] px-4 py-2 rounded text-base font-medium hover:bg-[{{ $theme->theme_hover }}] transition">
                    Dashboard
                </a>
            </div>
        </div>

        <div class="w-full bg-white rounded shadow px-6 py-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="border border-gray-200 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3 bg-[#E0002D]">
                        <span class="text-white text-xl font-semibold">RedX</span>
                        <i class="ri-motorbike-fill text-3xl text-white opacity-80"></i>
                    </div>

                    <form action="{{ route('admin.courier.store') }}" method="POST"
                        class="grid grid-cols-1 gap-3 px-4 py-4">
                        @csrf
                        <input type="hidden" name="type" value="redx">

                        @foreach (['Client Id' => 'api_key', 'Client Secret' => 'secret_key', 'Base URL' => 'url', 'Token' => 'token'] as $label => $name)
                            <div>
                                <label class="block text-sm text-gray-600 mb-1 font-medium">{{ $label }}</label>
                                <input type="{{ $name === 'url' ? 'url' : 'text' }}" name="{{ $name }}"
                                    placeholder="Enter {{ $label }}" value="{{ old($name, $redx?->$name) }}"
                                    class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2 focus:ring-2 focus:ring-[#E0002D] outline-none transition-all">
                            </div>
                        @endforeach

                        <div class="flex items-center justify-between mt-1">
                            <label class="text-gray-700 font-medium">Status</label>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="status" class="sr-only peer"
                                    {{ isset($redx) && $redx->status ? 'checked' : '' }}>
                                <div
                                    class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-[#E0002D]">
                                </div>
                            </label>
                        </div>

                        <button type="submit"
                            class="w-full mt-2 rounded-md bg-[#E0002D] hover:bg-[#c10025] text-white py-2.5 font-medium transition-all">
                            Save RedX Config
                        </button>
                    </form>
                </div>

                <div class="border border-gray-200 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3 bg-[#10B981]">
                        <span class="text-white text-xl font-semibold">Steadfast</span>
                        <i class="ri-truck-fill text-3xl text-white opacity-80"></i>
                    </div>

                    <form action="{{ route('admin.courier.store') }}" method="POST"
                        class="grid grid-cols-1 gap-3 px-4 py-4">
                        @csrf
                        <input type="hidden" name="type" value="steadfast">

                        @foreach (['API Key' => 'api_key', 'Secret Key' => 'secret_key', 'Base URL' => 'url', 'Token' => 'token'] as $label => $name)
                            <div>
                                <label class="block text-sm text-gray-600 mb-1 font-medium">{{ $label }}</label>
                                <input type="{{ $name === 'url' ? 'url' : 'text' }}" name="{{ $name }}"
                                    placeholder="Enter {{ $label }}" value="{{ old($name, $steadfast?->$name) }}"
                                    class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2 focus:ring-2 focus:ring-emerald-500 outline-none transition-all">
                            </div>
                        @endforeach

                        <div class="flex items-center justify-between mt-1">
                            <label class="text-gray-700 font-medium">Status</label>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="status" class="sr-only peer"
                                    {{ isset($steadfast) && $steadfast->status ? 'checked' : '' }}>
                                <div
                                    class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-emerald-500">
                                </div>
                            </label>
                        </div>

                        <button type="submit"
                            class="w-full mt-2 rounded-md bg-emerald-600 hover:bg-emerald-700 text-white py-2.5 font-medium transition-all">
                            Save Steadfast Config
                        </button>
                    </form>
                </div>
            </div>

            <div class="mt-8">
                <div class="border border-gray-200 bg-white rounded-lg overflow-hidden shadow-sm">
                    <div class="flex justify-between items-center px-4 py-3 bg-[#4F46E5]">
                        <div class="flex flex-col">
                            <span class="text-white text-xl font-semibold">Fraud Detection API</span>
                            <span class="text-xs text-indigo-100 italic">Powered by BD Courier API</span>
                        </div>
                        <i class="ri-shield-check-fill text-3xl text-white"></i>
                    </div>

                    <form action="{{ route('admin.fraud.store') }}" method="POST" class="px-4 py-6">
                        @csrf
                        <div>
                            <label class="block text-sm text-gray-600 mb-2 font-medium">API Key</label>
                            <input type="text" placeholder="Enter BD Courier Fraud API Key"
                                value="{{ old('fraud_api', $setting->fraud_api) }}" name="fraud_api"
                                class="w-full rounded-md border border-gray-300 text-gray-700 px-3 py-2.5 focus:ring-2 focus:ring-indigo-500 outline-none transition-all">
                            <p class="text-xs text-gray-400 mt-2">This API helps you detect potentially fraudulent orders
                                based on phone numbers.</p>
                        </div>

                        <button type="submit"
                            class="mt-4 px-6 py-2.5 rounded-md bg-indigo-600 hover:bg-indigo-700 text-white font-medium transition-all">
                            Update Fraud API
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
