<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Order extends Model
{
    protected $fillable = [
        'invoice_id', 'ip_address' , 'user_agent' , 'total', 'discount', 'tracking_id', 'courier_method', 'shipping_charge', 'order_status', 'payment_status', 'customer_id'
    ];

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function payment()
    {
        return $this->hasOne(Payment::class);
    }

    public function shipping()
    {
        return $this->hasOne(Shipping::class);
    }

    public static function boot()
    {
        parent::boot();

        static::creating(function ($order) {
            if (empty($order->invoice_id)) {
                $order->invoice_id = (string) rand(100000000, 999999999);
            }
        });

        static::deleting(function ($order) {
            $order->items()->delete();

            $order->payment()->delete();

            $order->shipping()->delete();
        });
    }
}
