<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerManageController extends Controller
{
    public function index(Request $request)
    {
        $query = Customer::query();

        if ($request->filled('search')) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('name', 'LIKE', "%{$search}%")
                  ->orWhere('phone', 'LIKE', "%{$search}%")
                  ->orWhere('email', 'LIKE', "%{$search}%");
            });
        }

        $customers = $query->latest()->paginate(20);

        return view('backend.customer.index', compact('customers'));
    }

    public function status($id)
    {
        $customer = Customer::findOrFail($id);

        if ($customer->status == 'active') {
            $customer->status = 'inactive';
            $message = 'Customer deactivated successfully.';
        } else {
            $customer->status = 'active';
            $message = 'Customer activated successfully.';
        }

        $customer->save();

        return redirect()->back()->with('success', $message);
    }

    public function destroy($id)
    {
        try {
            $customer = Customer::findOrFail($id);
            $customer->delete();

            return redirect()->back()->with('success', 'Customer deleted successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Something went wrong! Please try again.');
        }
    }
}